/**************************************************************************\
 *  aRT : API R - TerraLib                                                *
 *  Copyright (C) 2003-2005  LEG                                          *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU Lesser General Public      *
 *  License along with this library.                                      *
\**************************************************************************/

#include "SEXPbasic.h"

extern "C"{

SEXP GetListElement(SEXP list, char *str) {
  SEXP names;
  SEXP elmt = (SEXP) NULL;
  char* tempStr;

  PROTECT(names = getAttrib(list, R_NamesSymbol));
  for (int i = 0; i <= Rf_length(names)-1; i++) {
    tempStr = CHAR(STRING_ELT(names, i));
    if (strcmp(tempStr, str) == 0) {
      elmt = VECTOR_ELT(list, i);
      break;
    }
  } 
  UNPROTECT(1);
  return elmt;
}

SEXP AsDataFrame(SEXP list, SEXP rownames)
{
	SEXP classname = allocVector(STRSXP, 1);
	SET_STRING_ELT( classname, 0, mkChar("data.frame") );
	
	SET_CLASS(list, classname);
	setAttrib(list, R_RowNamesSymbol, rownames);

	return list;
}

}

