\name{aRTlayer-getSetMetric}
\docType{object}
\alias{getSetMetric,aRTlayer-method}
\alias{getSetMetric}
\alias{union}
\alias{difference}
\alias{xor}
\alias{intersection}

\title{"aRTlayer getSetMetric"}

\description{
  Return metrics evolving set operations (union, intersection, ...).
}

\section{Arguments}{
  \describe{
  \item{metric:}{A set metric among:}
  \itemize{
  	\item "union"
  	\item "intersection"
  	\item "difference"
  	\item "xor"
  }
  
  \item{ids:}{The ids which to be used in the operation. Metrics "d" and "x" use only
  two ids.}
  }
}

\examples{
\dontrun{
## difference between two geometries
getSetMetric(layer, "d", ids=c("1", "2"))

## union of all geometries of the layer
getSetMetric(layer, "u", ids=getGeometry(layer)$id)
}
}

\keyword{methods}
\references{\url{http://www.est.ufpr.br/aRT}}
\author{Pedro Ribeiro de Andrade Neto}

\seealso{
   See \code{aRTlayer-class} to the description of this class.
}

% vim: syntax=tex
