\name{aRTlayer-class}
\docType{class}
\alias{aRTlayer}
\alias{aRTlayer-class}
\alias{initialize,aRTlayer-method}

\title{Class "aRTlayer"}
\description{Class that represents a layer of information in the database. It can insert
geometries into the database, process them and create \code{aRTtable}, \code{aRTtheme} 
and \code{aRTproxy} objects.
TerraLib layers can stores various geometries in a layer, but in aRT, for simplify,
each layer stores only one type of geometry.}

\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("aRTlayer", aRTdb, layername, proj)}.
}

\section{Slots}{
  \describe{
    \item{\code{pointer}:}{An external pointer. DO NOT change it!}
  }
}

\section{Extends}{
Class \code{"aRTcomponent"}, directly.
}

\section{Methods}{
  \describe{
    \item{initialize:}{Initializer of aRTlayer class.}
    \item{showTables:}{Shows all information tables in the layer}
    \item{addPoints:}{Inserts points in the layer.}
    \item{addPolygons:}{Inserts polygons in the layer.}
    \item{addLines:}{Inserts lines in the layer. (not implemented yet)}
	\item{getGeometry:}{Returns the geometries stored in the layer.}
	\item{getAttributes:}{Returns the stored attributes.}
	\item{getMetric:}{Returns a metric operations (buffer, length, area, convex hull).}
	\item{getSetMetric:}{Calculates a set operation (union, difference, intersection, xor).}
	\item{getNN:}{(not implemented yet)}
	\item{getRelation:}{(not implemented yet)}
  }
}

\references{\url{http://www.est.ufpr.br/aRT}}
\author{Marcos Aurelio Carrero and Pedro Ribeiro de Andrade Neto}
\keyword{database}
\seealso{
 See \code{aRTlayer-METHOD} for a method of this class or \code{CLASSNAME-class} for links to other classes.
}

% vim: syntax=tex
