\name{aRTdb-class}
\docType{class}
\alias{aRTdb-class}
\alias{initialize,aRTdb-method}

\title{Class "aRTdb"}

\description{Class that opens, creates and manipulates a database. TerraLib layers
can stores various geometries in a layer, but in aRT, for simplification, layers
stores only a type of geometry.}

\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("aRTdb", aRTobject, dbname, create=T)}.
}

\section{Slots}{
  \describe{
    \item{\code{pointer}:}{An external pointer to a TerraLib object. DO NOT change it!}
  }
}

\section{Extends}{
Class \code{aRTcomponent}, directly.
}

\section{Methods}{
  \describe{
    \item{createView:}{Creates an empty View in the database.}
    \item{importShape:}{Imports a shapefile to the database.}
    \item{initialize:}{Initializer of aRTdb class}
    \item{showLayers:}{Shows all the available layers.}
    \item{showThemes:}{Shows all the available themes.}
    \item{showViews:}{Show all the available views.}
    \item{deleteLayer:}{Delete a layer in the database.}
    \item{deleteTheme:}{Delete a theme in the database.}
    \item{deleteView:}{Delete a view in the database.}
  }
}

\references{\url{http://www.est.ufpr.br/aRT}}

\author{Marcos Aurelio Carrero and Pedro Ribeiro de Andrade Neto}

\keyword{database}
\note{The View is only destinate to TerraView users. It has no importance
inside R.}
\keywords{database}
\seealso{
 See \code{aRTdb-METHOD} for a method of this class or
     \code{CLASSNAME-class} for links to other classes.
}

% vim: syntax=tex
