#  aRT : API R - TerraLib                                                
#  Copyright (C) 2003-2005  LEG                                          
#                                                                        
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License as published by  
#  the Free Software Foundation; either version 2 of the License, or     
#  (at your option) any later version.                                   
#                                                                        
#  This program is distributed in the hope that it will be useful,       
#  but WITHOUT ANY WARRANTY; without even the implied warranty of        
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
#  GNU General Public License for more details.                          
#                                                                        
#  You should have received a copy of the GNU Lesser General Public      
#  License along with this library.

# splancs.R
# functions to convert data from and to _splancs_ package
# sp == splancs

".aRT2sp" <- function(data)
{
	stop("not implemented yet")
}

".sp2aRTpoints" <- function(data)
{
	if(!any(names(data) == "x") || !any(names(data) == "y"))
		stop("Data does not have points")

    aRTdata<-list()
    aRTdata$points <- lapply(1:length(data$x), function(i,data) list(x=data$x[i], y=data$y[i]), data)
    aRTdata$id <- paste(1:length(aRTdata$points))
    aRTdata
}

".sp2aRTpolygons" <- function(data)
{
	if(!any(names(data) == "poly"))
		stop("Data does not have polygons")

    aRTdata<-list()
	rbind(unique(data$poly), data$poly[1,])->data$poly
	# to avoid two consecultive equal points 
	
    aRTdata$polygons <- list(list(x=data$poly[,1], y=data$poly[,2]))
    length(aRTdata$polygons)
	aRTdata$id <- paste(1:length(aRTdata$polygons))
    aRTdata
}

