
require(sp)

as.SpatialPoints = function(data)
{
	points = data$points
	pts = NULL
    for(i in 1:length(points))
    {
		pts = rbind(pts, cbind(x=points[[i]]$x, y=points[[i]]$y))
    }
	SP = SpatialPoints(pts)
	return(SP)
}

#as.SpatialPointsDataFrame = function(data)
#{
#	points = as.SpatialPoints(data)
#	df = 2
#	return(SpatialPointsDataFrame(data, df))
#}

as.SpatialLines = function(data)
{
	lines = data$lines
	slines = NULL
    for(i in 1:length(lines))
    {
        line = lines[[i]]
		sline = list(Sline(cbind(line$x, line$y)))
		slines = c(slines, list(Slines(sline)))
    }
	SL = SpatialLines(slines)
	return(SL)
}

as.SpatialRings = function(data)
{
	pols = data$polygons
	sring = NULL
    for(i in 1:length(pols))
    {
        pol = pols[[i]]
        j = 1
		spol = NULL
		
        for(k in 2:length(pol$x))
        {
            if(j != k && pol$x[j] == pol$x[k] && pol$y[j] == pol$y[k])
            {
				spol = c(spol, list(Sring(cbind(pol$x[j:k], pol$y[j:k]))))
                j = k+1
            }
        }
		sring = c(sring, list(Srings(spol, data$id[i])))
    }
	SR = SpatialRings(sring, 1:length(pols))
	return(SR)
}

setGeneric("as.aRTgeometry", function(object) standardGeneric("as.aRTgeometry"))

setMethod("as.aRTgeometry", "SpatialPoints", function(object) {
	mat = coordinates(object)
    colnames(mat) = c("x", "y")

	result = NULL
	result$points = apply(mat, 1, as.list)
	result$id = paste(1:length(result$points))
	class(result) = "aRTgeometry"

	return (result)
})

setMethod("as.aRTgeometry", "SpatialRings", function(object) {
	pols = getSRpolygonsSlot(object)
	rpols = NULL
	for(i in 1:length(pols))
	{
		srings = getSringsSringsSlot(pols[[i]])
		r = NULL
		for(j in length(srings):1)
		{
			r$x = c(getSringCoordsSlot(srings[[j]])[,1], r$x)
			r$y = c(getSringCoordsSlot(srings[[j]])[,2], r$y)
		}
		rpols = c(rpols, list(r))
	}
	result = NULL
	result$polygons = rpols
	result$id = getSRSringsIDSlots(object)
	class(result) = "aRTgeometry"

	return (result)
})

