#  aRT : API R - TerraLib                                                
#  Copyright (C) 2003-2005  LEG                                          
#                                                                        
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License as published by  
#  the Free Software Foundation; either version 2 of the License, or     
#  (at your option) any later version.                                   
#                                                                        
#  This program is distributed in the hope that it will be useful,       
#  but WITHOUT ANY WARRANTY; without even the implied warranty of        
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
#  GNU General Public License for more details.                          
#                                                                        
#  You should have received a copy of the GNU Lesser General Public      
#  License along with this library.

iii=10000

setGeneric("plot",  function(x,y, ...) standardGeneric("plot"))
setMethod("plot", "aRTtheme", function(x, y, ...) {
  out <- getGeometry(x)
  plot(out, ...)
  return(invisible())
})

setMethod("plot", "aRTlayer", function(x, y, ...) {
  if( summary(x)$raster == "yes" )
  {
  	out <- getRaster(x)
	image(out, asp=1, ...)
  }
  else
  {
    out <- getGeometry(x)
    plot(out, ...)
  }
  return(invisible())
})

.aRTclearPlot <- function()
{
	rm(.aRTdataplot)
}

.aRT.mergedata <- function (data)
{
	if(! any(ls(all.names=T) == ".aRTdataplot"))
		return(data)

	result<-list()
	result$points <- c(data$points, .aRTdataplot$points, list())
	result$polygons <- c(data$polygons, .aRTdataplot$polygons, list())
	result
}

.selectData <- function(data, id)
{
	if(!is.null(data$polygons))
	{
		data$polygons<-data$polygons[which(is.element(data$id, id))]
	}
	if(!is.null(data$points))
	{
	    data$points<-data$points[which(is.element(data$id, id))]
	}
	if(!is.null(data$lines))
	{
	    data$lines<-data$lines[which(is.element(data$id, id))]
	}
					
	data
}

plot.aRTgeometry <- function(x, save = FALSE, add = FALSE, id = NULL, ...)
# implementar para plotar apenas os ids passados como argumento
{
	#if(save).aRTdataplot <- aRT.mergedata(data)
	#else	.aRTdataplot <- data
	
	if(!is.null(id))
		x<- .selectData(x, id)

	if(!add)
	{
	   	grid<- .expand( .removenulls(c(x$polygons, x$points, x$lines, list()) ))
    	plot(expand.grid(grid), type="n", asp=1, ...)
	}

	.aRTplot(x, ...)

#	if( !save )	rm(.aRTdataplot)
}

.aRTplot <- function(data, ...)
{
	if( any(is.element(names(data), "polygons")) ) .plotpol( .removenulls(data$polygons), ... )
    if( any(is.element(names(data), "points"  )) ) .plotpoints( .removenulls(data$points), ... )
    if( any(is.element(names(data), "lines"   )) ) .plotlines( .removenulls(data$lines), ... )
}

# remove all positions that are null, and then cant be plotted
.removenulls <- function(data)
{
	return ( data[which(!sapply(data, is.null))] )
}

.expand <- function(data)
{
    p<-list(x=range(sapply(data, function(x) range(x$x))),
            y=range(sapply(data, function(x) range(x$y))))
	return (p)
}

.plotpol <-function(pols, ...)
{
	# draws each point repetition as one polygon
    for(i in 1:length(pols))
	{
		pol <- pols[[i]]
		j<-1

		for(k in 2:length(pol$x))
		{
		    if(j != k && pol$x[j] == pol$x[k] && pol$y[j] == pol$y[k])
		    {
				polygon( list(x=pol$x[j:k], y = pol$y[j:k]), ... )
				file = paste("recife", iii, ".eps", sep="")
#				dev.copy2eps(file=file)
				iii=iii+1
		        j<-k+1
		    }
		}		
	}
    return(invisible())
}

# cex, pch
.plotpoints <- function(points, ...)
{
	sapply( 1:length(points), function(x)  points(points[[x]], ...))
	file = paste("recife", iii, ".eps", sep="")
	iii=iii+1
#	dev.copy2eps(file=file)
	return(invisible())
}

.plotlines <- function(lines, ...)
{
	sapply( 1:length(lines), function(x)  lines(lines[[x]]$x, lines[[x]]$y, ...))
	file = paste("recife", iii, ".eps", sep="")
#	dev.copy2eps(file=file)
	iii=iii+1
	return(invisible())
}
