setClass("aRTproxy", contains = "aRTcomponent")

setMethod("initialize", "aRTproxy", function(.Object,
                                             parent,
                                             loadgeom = FALSE,
                                             loadatt = TRUE)
{

  if (is.object(parent) && class(parent) == "aRTlayer")
  {
    out = .Call("cppProxy",
                parent@pointer,
                list(loadgeom=loadgeom,
                     loadatt=loadatt),
                PACKAGE="aRT")
  }
  else if (is.object(parent) && class(parent) == "aRTtheme")
  {
	out = .Call("cppOpen",
	            parent@pointer,
				list(loadgeom=loadgeom,
				     loadatt=loadatt),
				PACKAGE="aRT")
  }
  else stop("Argument \"parent\" must an object of class aRTlayer or aRTtheme\n")

  if (is.null(out))
    stop("Could not create the aRTproxy object\n")

  .Object@pointer <- out
  reg.finalizer(.Object@pointer, .aRTremove)
  .Object
})

setGeneric("getNext",   function(x) standardGeneric("getNext"))
setGeneric("nextSlide", function(x) standardGeneric("nextSlide"))

# TODO: return all data in sp format
setMethod("getNext", "aRTproxy", function(x) {
 .Call("cppGetNext",
       x@pointer,
       PACKAGE="aRT")
})

