###################################################
### chunk number 1: boxcox
###################################################
library(MASS)
par(mfrow = c(2,2), cex = 0.7)

with(Cars93, plot(Weight, MPG.city, col = "green4"))

FEM.orig <- lm(MPG.city ~ Weight, Cars93)
plot(fitted(FEM.orig), resid(FEM.orig), col = "navy")
abline(h=0, lty = "dashed", col="red")

# try a Box-Cox transformation
boxcox(FEM.orig, lambda = seq(-1.75, -0.5, len=10))


###################################################
### chunk number 2: boxcox2
###################################################
# the reciprocal transform is acceptable and natural
with(Cars93, plot(Weight, 1000/MPG.city, col = "red"))


###################################################
### chunk number 3: cars93_1
###################################################
library(MASS)
par(mfrow = c(2,2), cex = 0.7)

with(Cars93, plot(Weight, MPG.city, col = "green4"))

FEM.orig <- lm(MPG.city ~ Weight, Cars93)
plot(fitted(FEM.orig), resid(FEM.orig), col = "navy")
abline(h=0, lty = "dashed", col="red")

# try a Box-Cox transformation
boxcox(FEM.orig, lambda = seq(-2.0, -0.4, len=10), xlab = expression(lambda))

# the reciprocal transform is acceptable and natural
with(Cars93, plot(Weight, 1000/MPG.city, col = "red"))



###################################################
### chunk number 4: logtrans
###################################################
library(MASS)
logtrans(Days ~ Eth*Lrn*Age*Sex, data = quine, 
         xlab = expression(alpha))


###################################################
### chunk number 5: logtrans_2
###################################################
library(MASS)
logtrans(Days ~ Eth*Lrn*Age*Sex, data = quine, xlab = expression(alpha))


###################################################
### chunk number 6: cow
###################################################
# Average daily fat yields (kg/day) from milk
# from a single cow for each of 35 weeks
# McCulloch (2001)
# Ruppert, Cressie, Carroll (1989)
#   - Biometrics, 45: 637-656

Milk <- data.frame(week = 1:35, 
yield = c(0.31, 0.39, 0.50, 0.58, 0.59, 0.64, 0.68, 0.66, 
          0.67, 0.70, 0.72, 0.68, 0.65, 0.64, 0.57, 0.48, 
          0.46, 0.45, 0.31, 0.33, 0.36, 0.30, 0.26, 0.34, 
          0.29, 0.31, 0.29, 0.20, 0.15, 0.18, 0.11, 0.07, 
          0.06, 0.01, 0.01)) 

### standard and log-link model

M1 <- lm(log(yield) ~ week + log(week), Milk)
M2 <- glm(yield ~ week + log(week), quasi(link = "log"), Milk)

### predictions for a fine-grid time scale

pMilk <- data.frame(week = seq(1, 35, by = 0.1))
pMilk <- transform(pMilk,
          pM1 = exp(predict(M1, pMilk)),
          pM2 = predict(M2, pMilk, type="resp"))

yl <- range(Milk$yield, pMilk$pM1, pMilk$pM2) # for plotting

### display the results

with(Milk, plot(week, yield, pch = 8, cex = 0.8, xlab = "Week", ylab =
  "Fat yield (kg/day)", ylim = yl, col = "navy")) 

with(pMilk, {
  lines(week, pM1, col = "red") 
  lines(week, pM2, col = "green4") 
})
  legend("topright", c("observed", "lm, log-transformed", "glm, log-link"), 
         lty = c(NA, "solid", "solid"), 
         pch = c(8, NA, NA),
         col = c("navy", "red", "green4"), cex = 0.8, bty = "n")


###################################################
### chunk number 7: cowFig
###################################################

yl <- range(Milk$yield, pMilk$pM1, pMilk$pM2) # for plotting

### display the results

with(Milk,
  plot(week, yield, pch = 8, cex = 0.8, xlab = "Week",
    ylab = "Fat yield (kg/day)", ylim = yl,
    col = "navy")
)
with(pMilk, {
  lines(week, pM1, col = "red")
  lines(week, pM2, col = "green4")
})
legend("topright",
  c("observed", "lm, log-transformed", "glm, log-link"),
  lty = c(NA, "solid", "solid"),
  pch = c(8, NA, NA),
  col = c("navy", "red", "green4"),
  cex = 0.8, bty = "n")


###################################################
### chunk number 8: cowFig2
###################################################
with(Milk,
  plot(week, yield, pch = 8, cex = 0.8, xlab = "Week",
    ylab = "Fat yield (kg/day)", ylim = yl, log = "y",
    col = "navy")
)
with(pMilk, {
  lines(week, pM1, col = "red")
  lines(week, pM2, col = "green4")
})
legend("bottomleft",
  c("observed", "lm, log-transformed", "glm, log-link"),
  lty = c(NA, "solid", "solid"),
  pch = c(8, NA, NA),
  col = c("navy", "red", "green4"),
  cex = 0.8, bty = "n")


###################################################
### chunk number 9: quine
###################################################
quine.1 <- glm(Days ~ Age*Eth*Sex*Lrn, poisson, quine)


###################################################
### chunk number 10: quine_2
###################################################
with(quine.1, c("D_M" = deviance, "n-p" = df.residual))


