### Positive Poisson, an example

fm <- glm(Days ~ Sex/(Age + Eth*Lrn), poisson, quine)

gm <- glm(Days ~ Sex/(Age + Eth*Lrn), positive.poisson,
            quine, subset = Days > 0)

sum(quine$Days == 0)
# [1] 9

cbind(coef(fm), coef(gm))

#                        [,1]       [,2]
# (Intercept)      2.89964439  2.9228022
# SexM            -0.39728328 -0.3834256
# SexF:AgeF1      -0.48940800 -0.4811170
# SexM:AgeF1      -0.82266957 -0.7052634
# SexF:AgeF2      -0.19579076 -0.1823220
# SexM:AgeF2       0.62625967  0.5803821
# SexF:AgeF3      -0.21627314 -0.1527970
# SexM:AgeF3       1.01690949  0.9683722
# SexF:EthN       -0.08594811 -0.1429474
# SexM:EthN       -0.49064643 -0.3064356
# SexF:LrnSL       0.73625109  0.7029153
# SexM:LrnSL       0.33779217  0.3153807
# SexF:EthN:LrnSL -1.27702273 -1.1211551
# SexM:EthN:LrnSL  0.59021257  0.4675063

plot(predict(fm), predict(gm, quine), asp=1)
abline(0,1)