TigersW<-read.csv("../CSV/TigersW.csv")
### penalised estimation the direct way.

chebyshev <- local({      ## generate chebyshev polynomial basis
  zfill <- function(x) {  ## for neater labels
    m <- max(n <- nchar(x))
    z <- paste(rep(0, m), sep = "")
    paste(substring(z, 0, m-n), x, sep = "")
  }

  function(x, p, const = FALSE) {
    rx <- range(x)
    if((dx <- rx[2] - rx[1]) < sqrt(.Machine$double.eps))
        stop("inadequate range")
    z <- acos(2*(x - rx[1])/dx - 1)
    Cp <- matrix(1, length(z), p+1)
    for(j in 1:p)
    Cp[, j+1] <- cos(j*z)
    dimnames(Cp) <- list(NULL, paste("C", zfill(0:p), sep = ""))
    if(const) Cp else Cp[, -1]
  }
})
  
Bspline <- function(x, k = 10) { ### local B spline basis, equally spaced
  rx <- range(x)
  k <- max(4, k)
  z <- 2*(x - rx[1])/(rx[2] - rx[1]) - 1
  k <- k-1
  del <- 2/(k-2)
  zs <- seq(-1 - 3*del, 1 + 4*del, by = del)
  B <- matrix(0, length(x), k+5)
  for(i in 1:(k+5))
    B[, i] <- pmax(0, (z-zs[i])^3)
  k <- k+1
  for(j in 1:k)
    B[, j] <- B[,j] - 4*B[,j+1] + 6*B[,j+2] - 4*B[,j+3] + B[,j+4]
  B[, 1:k]
}
### constant and linear functions are included

graphics.off()
x11(height = 4, width = 8.5)
par(mfrow=c(1,2))
x <- seq(0, 10, len = 100)
y <- 2 + 3*x
B <- Bspline(x, 15)
b <- lsfit(B, y, int = FALSE)$coef
plot(x, y, type = "n", ylim = c(0, 32))
lines(x, B %*% b, col = "red", lwd = 1.5)
for(j in 1:15)
  lines(x, B[, j]*b[j], col = j)

y <- rep(1, 100)
b <- lsfit(B, y, int = FALSE)$coef
plot(x, y, type = "n", ylim = c(0,1.25))
lines(x, B %*% b, col = "red", lwd = 1.5)
for(j in 1:15)
  lines(x, B[, j]*b[j], col = j)

### fit a penalized regression

fitPenalized <- function(x, y, k = length(unique(x)), lambda, d = 2) {
  B <- Bspline(x, k)
  D <- diff(diag(k), diff = d)
  X <- rbind(B, sqrt(lambda) * D)
  Y <- c(y, rep(0, nrow(D)))
  fit <- lsfit(X, Y, int = FALSE)
  n <- length(y)
  rs <- fit$resid[1:n]
  dfr <- sum(rowSums((X %*% solve(crossprod(X) + lambda * crossprod(D))) * X))
  AIC <- n*log(sum(rs^2)/n) + 2*dfr
  BIC <- AIC + (log(n) - 2)*dfr
  structure(list(coefficients = fit$coef, dfr = dfr,
    residuals = rs, fitted = y - rs,
    AIC = AIC, BIC = BIC), class = "fitPenalized")
}


with(mcycle, {
  graphics.off()
  x11(height = 6, width = 12)
  par(mfrow = c(2,4))
  rf <- sqrt(1000)
  lambda <- 1/100

  for(j in 1:8) {
    plot(times, accel, cex = 0.7)
    ft <- fitPenalized(times, accel, lambda = lambda)
    with(ft, cat(j, "  df:", round(dfr, 3),
                    " log10(lambda):", log10(lambda),
                    "  AIC:", AIC,
                    "  BIC:", BIC, "\n"))
    lines(times, fitted(ft), col = j)
    title(main = paste("AIC =", round(ft$AIC-919, 2)), cex = 0.7)
    lambda <- lambda/rf
  }
})

## find best lambda by two crieria

fAIC <- function(loglambda)
  with(mcycle, fitPenalized(times, accel, lambda = 10^loglambda)$AIC)
fBIC <- function(loglambda)
  with(mcycle, fitPenalized(times, accel, lambda = 10^loglambda)$BIC)

lAIC <- optimize(fAIC, -c(4,9))
lBIC <- optimize(fBIC, -c(4,9))

graphics.off()
x11(height = 5, width = 10)
par(mfrow=c(1,2))
with(mcycle, {
  plot(times, accel, cex = 0.7)
  ft <- fitPenalized(times, accel, lambda = 10^lAIC$minimum)
  lines(times, fitted(ft), col = "red")
  title(main = paste("AIC, log10(lambda) =", round(lAIC$min, 3)), cex = 0.5)

  plot(times, accel, cex = 0.7)
  ft <- fitPenalized(times, accel, lambda = 10^lBIC$minimum)
  lines(times, fitted(ft), col = "blue")
  title(main = paste("BIC, log10(lambda) =", round(lBIC$min, 3)), cex = 0.5)
})
  
  
