###################################################
### chunk number 1: pe_1
###################################################
library(MASS)
with(mcycle, plot(times, accel, 
  ylab = "Accelleration", xlab = "Time in ms"))


###################################################
### chunk number 2: pe_2 eval=FALSE
###################################################
## p_05 <- lm(accel ~ poly(times, 05), mcycle)
## p_10 <- lm(accel ~ poly(times, 10), mcycle)
## p_15 <- lm(accel ~ poly(times, 15), mcycle)
## p_20 <- lm(accel ~ poly(times, 20), mcycle)
## with(mcycle, plot(times, accel, ylab = "Accelleration", 
##                   xlab = "Time in ms"))
## dat <- with(mcycle,  data.frame(times = 
##     seq(min(times), max(times), len = 1000)))
## with(dat, {
##   lines(times, predict(p_05, dat), col = "red") 
##   lines(times, predict(p_10, dat), col = "blue") 
##   lines(times, predict(p_15, dat), col = "green4") 
##   lines(times, predict(p_20, dat), col = "gold") 
## })
## legend("bottomleft", c("p_05","p_10","p_15","p_20"), lty = 1, 
##        col = c("red","blue","green4","gold"), lwd = 2, 
##        bty = "n", cex = 0.75)


###################################################
### chunk number 3: pe_2a
###################################################
p_05 <- lm(accel ~ poly(times, 05), mcycle)
p_10 <- lm(accel ~ poly(times, 10), mcycle)
p_15 <- lm(accel ~ poly(times, 15), mcycle)
p_20 <- lm(accel ~ poly(times, 20), mcycle)
with(mcycle, plot(times, accel, ylab = "Accelleration", 
                  xlab = "Time in ms"))
dat <- with(mcycle,  data.frame(times = 
    seq(min(times), max(times), len = 1000)))
with(dat, {
  lines(times, predict(p_05, dat), col = "red") 
  lines(times, predict(p_10, dat), col = "blue") 
  lines(times, predict(p_15, dat), col = "green4") 
  lines(times, predict(p_20, dat), col = "gold") 
})
legend("bottomleft", c("p_05","p_10","p_15","p_20"), lty = 1, 
       col = c("red","blue","green4","gold"), lwd = 2, 
       bty = "n", cex = 0.75)


###################################################
### chunk number 4: pe_3
###################################################
x <- seq(0, 10, len = 1001)
P <- function(j, x) pmax(0, (x - j)^3)
B1 <- P(1,x) - 4*P(2,x) + 6*P(3,x) - 4*P(4,x) + P(5,x) 
B4 <- P(4,x) - 4*P(5,x) + 6*P(6,x) - 4*P(7,x) + P(8,x) 
plot(x, B1, type = "l", col = "red", lwd = 1.5)
lines(x, B4, col = "blue", lwd = 1.5, lty = "dashed")


###################################################
### chunk number 5: pe_4
###################################################
Bspline <- function(x, k = 10) { ### local B spline basis, equally spaced
  rx <- range(x)
  k <- max(4, k)
  z <- 2*(x - rx[1])/(rx[2] - rx[1]) - 1
  k <- k-1
  del <- 2/(k-2)
  zs <- seq(-1 - 3*del, 1 + 4*del, by = del)
  B <- matrix(0, length(x), k+5)
  for(i in 1:(k+5))
    B[, i] <- pmax(0, (z-zs[i])^3)
  k <- k+1
  for(j in 1:k)
    B[, j] <- B[,j] - 4*B[,j+1] + 6*B[,j+2] - 4*B[,j+3] + B[,j+4]
  B[, 1:k]
}


###################################################
### chunk number 6: pe_4
###################################################
par(mfrow=c(1,2))
x <- seq(0, 10, len = 100)
y <- 2 + 3*x
B <- Bspline(x, 15)
b <- lsfit(B, y, int = FALSE)$coef
plot(x, y, type = "n", ylim = c(0, 32))
lines(x, B %*% b, col = "red", lwd = 1.5)
for(j in 1:15)
  lines(x, B[, j]*b[j], col = j)

y <- rep(1, 100)
b <- lsfit(B, y, int = FALSE)$coef
plot(x, y, type = "n", ylim = c(0,1.25))
lines(x, B %*% b, col = "red", lwd = 1.5)
for(j in 1:15)
  lines(x, B[, j]*b[j], col = j)


###################################################
### chunk number 7: pe_5
###################################################
p_05 <- lm(accel ~ Bspline(times, 05)-1, mcycle)
p_10 <- lm(accel ~ Bspline(times, 10)-1, mcycle)
p_15 <- lm(accel ~ Bspline(times, 15)-1, mcycle)
p_20 <- lm(accel ~ Bspline(times, 20)-1, mcycle)
with(mcycle, plot(times, accel, ylab = "Accelleration", 
                  xlab = "Time in ms"))
dat <- with(mcycle,  data.frame(times = 
    seq(min(times), max(times), len = 1000)))
with(dat, {
  lines(times, predict(p_05, dat), col = "red") 
  lines(times, predict(p_10, dat), col = "blue") 
  lines(times, predict(p_15, dat), col = "green4") 
  lines(times, predict(p_20, dat), col = "gold") 
})
legend("bottomleft", c("p_05","p_10","p_15","p_20"), lty = 1, 
       col = c("red","blue","green4","gold"), lwd = 2, 
       bty = "n", cex = 0.75)


###################################################
### chunk number 8: pe_6
###################################################
b <- structure(coef(p_20), names=paste("B",1:20,sep=""))
c(Roughness1 = sum(diff(b)^2), Roughness2 = sum(diff(b, diff = 2)^2))


###################################################
### chunk number 9: pe_7
###################################################
### fit a penalized regression

fitPenalized <- function(x, y, 
      k = length(unique(x)), lambda, d = 2) {
  B <- Bspline(x, k)
  D <- diff(diag(k), diff = d)
  X <- rbind(B, sqrt(lambda) * D)
  Y <- c(y, rep(0, nrow(D)))
  fit <- lsfit(X, Y, int = FALSE)
  n <- length(y)
  rs <- fit$resid[1:n]
  dfr <- sum(rowSums((X %*% solve(crossprod(X) + 
          lambda * crossprod(D))) * X))
  AIC <- n*log(sum(rs^2)/n) + 2*dfr
  BIC <- AIC + (log(n) - 2)*dfr
  structure(list(coefficients = fit$coef, dfr = dfr,
    residuals = rs, fitted = y - rs,
    AIC = AIC, BIC = BIC), class = "fitPenalized")
}


###################################################
### chunk number 10: pe_8
###################################################
with(mcycle, {
  par(mfrow = c(2,4))
  rf <- sqrt(1000)  ## reduction factor
  lambda <- 1/100

  for(j in 1:8) {
    plot(times, accel, cex = 0.7)
    ft <- fitPenalized(times, accel, lambda = lambda)
    with(ft, cat(j, "  df:", round(dfr, 3),
                    " log10(lambda):", log10(lambda),
                    "  AIC:", AIC,
                    "  BIC:", BIC, "\n"))
    lines(times, fitted(ft), col = j)
    title(main = paste("lambda = 10^", log10(lambda), sep=""), cex = 0.7)
    lambda <- lambda/rf
  }
})


###################################################
### chunk number 11: pe_9
###################################################
## find best lambda by two crieria

fAIC <- function(loglambda)
  with(mcycle, fitPenalized(times, accel, 
                                lambda = 10^loglambda)$AIC)
fBIC <- function(loglambda)
  with(mcycle, fitPenalized(times, accel, 
                                lambda = 10^loglambda)$BIC)

lAIC <- optimize(fAIC, -c(4,9))
lBIC <- optimize(fBIC, -c(4,9))

par(mfrow=c(1,2))
with(mcycle, {
  plot(times, accel, cex = 0.7)
  ft <- fitPenalized(times, accel, lambda = 10^lAIC$minimum)
  lines(times, fitted(ft), col = "red")
  title(main = paste("AIC, log10(lambda) =", 
                           round(lAIC$min, 3)), cex = 0.5)

  plot(times, accel, cex = 0.7)
  ft <- fitPenalized(times, accel, lambda = 10^lBIC$minimum)
  lines(times, fitted(ft), col = "blue")
  title(main = paste("BIC, log10(lambda) =", 
                           round(lBIC$min, 3)), cex = 0.5)
})


###################################################
### chunk number 12: pe_10
###################################################
library(mgcv)
p_gam <- gam(accel ~ s(times), data = mcycle)
with(mcycle, plot(times, accel))
dat <- with(mcycle, data.frame(times = 
       seq(min(times), max(times), len = 1000)))
with(dat,
  lines(times, predict(p_gam, dat), col = "red"))


###################################################
### chunk number 13: tigers
###################################################
library(ASOR)
load("TigersW.RData")
Store(TigersW, Aus)

with(TigersW, plot(Longitude, Latitude, asp = 1,
              pch = 15, col = as.numeric(StockTig)))
Aus(add = T)  ## coastline 


###################################################
### chunk number 14: tigers_w
###################################################
names(TigersW)


###################################################
### chunk number 15: tigers_3 eval=FALSE
###################################################
## library(mgcv)
## t_gam <- gam(Fsemi ~ s(Longitude,Latitude) +
##          te(PDay, Depth_av) + te(PDay, Rland) +
##          s(Mud_av), quasibinomial, TigersW,
##          weight = Tiger, trace = T)


###################################################
### chunk number 16: tigers_4 eval=FALSE
###################################################
## t_gam_t <- update(t_gam, . ~ . + s(Time))


