### A demonstration of the difference
### between least squares and t-robust
### estimation

x <- rnorm(30)

sink("x.txt")
print(round(sort(x), 2))
sink()

fitT <- local({
  obj <- function(par, X) {
    mu <- par[1]
    sg <- exp(par[2])
    -sum(dt((X-mu)/sg, 3, log=TRUE) - par[2])
  }
  function(x, nu = 3) {
    p <- optim(c(0,0), obj, method = "BFGS", X = x)$par
    c(mu = p[1], sg = exp(p[2])*sqrt(nu/(nu-2)))
  }
})

th <- theta <- NULL
mx <- max(x)
x <- sort(x)[-length(x)]

for(x0 in mx + 0:20/2) {
  y <- c(x, x0)
  th <- rbind(th, c(x0=x0, fitT(y, 5)))
  theta <- rbind(theta, c(x0=x0, mu = mean(y), sg = sd(y)))
}

row.names(th) <- paste("T", 1:nrow(th))
row.names(theta) <- paste("N", 1:nrow(theta))
est <- rbind(data.frame(th,    Est = "t"),
             data.frame(theta, Est = "N"))
png(filename = "Sim_%03d.png", height = 600, width = 800)

print(xyplot(sg ~ mu, est, subset = Est == "t", type = "b",
  xlab = expression(hat(mu)),
  ylab = expression(hat(sigma)), pch=15))

print(xyplot(sg ~ mu, est, groups = Est, type = "b",
  xlab = expression(hat(mu)),
  ylab = expression(hat(sigma)), pch=15))

dev.off()
