## some useful date and time functions

today <- hoje <- function ()
as.Date("00:00:00", "%X")

udate <- function ()
format(Sys.time(), "%a %b %d %X %Y")

now <- agora <- function() format(Sys.time(), "%Y-%m-%d %H:%M:%S")

## a form suitable for Windows filenames
now_f <- agora_f <- function() gsub("[ :]", "_", as.character(now()))

date.stamp <- function (pos = "topleft", cex = 0.5, ...)
legend(pos, legend = now(), cex = cex, ...)

### Example

plot(rnorm(500), main = hoje())
date.stamp()

jpeg(filename = paste("Rplots", now_f(), "%03d.jpg", sep = "_"),
        height = 750, width = 900)
plot(1:10, main = "file 1")
date.stamp()
plot(rnorm(1000))
date.stamp()
dev.off()


