tRob <-
function (formula, data, subset, weights, na.action, method = "t",
    model = TRUE, x = FALSE, y = FALSE, contrasts = NULL, qr = TRUE,
    singular.ok = FALSE, offset, df = 5, ...)
{
    ret.x <- x
    ret.y <- y
    cl <- match.call()
    mf <- match.call(expand.dots = FALSE)
    m <- match(c("formula", "data", "subset", "weights", "na.action", 
        "offset"), names(mf), 0)
    mf <- mf[c(1, m)]
    mf$drop.unused.levels <- TRUE
    mf[[1]] <- as.name("model.frame")
    mf <- eval(mf, parent.frame())
    if (method == "model.frame") 
        return(mf)
    else if (method != "t")
        warning(gettextf("method = '%s' is not supported. Using 't'",
            method), domain = NA)
    mt <- attr(mf, "terms")
    y <- model.response(mf, "numeric")
    w <- as.vector(model.weights(mf))
    if (!is.null(w) && !is.numeric(w)) 
        stop("'weights' must be a numeric vector")
    offset <- as.vector(model.offset(mf))
    if (!is.null(offset)) {
        if (length(offset) == 1) 
            offset <- rep(offset, NROW(y))
        else if (length(offset) != NROW(y)) 
            stop(gettextf("number of offsets is %d, should equal %d (number of observations)", 
                length(offset), NROW(y)), domain = NA)
    }
    if (is.empty.model(mt)) {
        x <- NULL
        z <- list(coefficients = if (is.matrix(y)) matrix(, 0, 
            3) else numeric(0), residuals = y, fitted.values = 0 * 
            y, weights = w, rank = 0, df.residual = if (is.matrix(y)) nrow(y) else length(y))
        if (!is.null(offset)) {
            z$fitted.values <- offset
            z$residuals <- y - offset
        }
    }
    else {
        x <- model.matrix(mt, mf, contrasts)
        z <- if (is.null(w)) 
            lm.fit(x, y, offset = offset, singular.ok = singular.ok, 
                ...)
        else lm.wfit(x, y, w, offset = offset, singular.ok = singular.ok, 
            ...)
        b <- with(z, c(coefficients, log(sum(residuals^2)/df.residual)))
        p1 <- length(b)
        df <- df
        n <- nrow(x)
        obj <- function(par)
          -sum(dt((y - x %*% par[-p1])/exp(par[p1]), df = df, log = TRUE)) + n*par[p1]
        z$opt <- optim(b, obj, method = "BFGS", hessian = TRUE)
        nam <- c(names(z$coefficients), "log(sigma)")
        names(z$opt$par) <- nam
        z$par <- z$opt$par
        z$vcov <- MASS::ginv(z$opt$hessian)
        dimnames(z$vcov) <- list(nam, nam)
        z$SE <- structure(sqrt(diag(z$vcov)), names = nam)
        z$t_fitted <- x %*% z$par[-p1]
        z$t_residuals <- y - z$t_fitted
    }
    class(z) <- c("tRob", "lm")
    z$na.action <- attr(mf, "na.action")
    z$offset <- offset
    z$contrasts <- attr(x, "contrasts")
    z$xlevels <- .getXlevels(mt, mf)
    z$call <- cl
    z$terms <- mt
    if (model) 
        z$model <- mf
    if (ret.x) 
        z$x <- x
    if (ret.y) 
        z$y <- y
    if (!qr) 
        z$qr <- NULL
    z
}

summary.tRob <- function(object, correlation = FALSE, ...) {
  object$t_coefficients <- cbind(Parameter = object$par, SE = object$SE)
  if(correlation)
    object$correlation <- t(object$vcov/object$SE)/object$SE
  class(object) <- "summary.tRob"
  object
}

print.summary.tRob <- function(x, ...) {
  cat("Call:\n")
  print(x$call)
  cat("\nParameter estimates:\n")
  print(x$t_coefficients)
  if(!is.null(x$correlation)) {
    cat("\nCorrelations:\n")
    print(round(x$correlation, 4))
  }
  invisible(x)
}

coef.tRob <- function(object, ...) object$par[-length(object$par)]

parameters <- function(object, ...) UseMethod("parameters")
parameters.tRob <- function(object, ...) object$par

vcov.tRob <- function(object, ...) object$vcov
fitted.tRob <- function(object, ...) object$t_fitted
residuals.tRob <- function(object, ...) object$t_residuals



  