### intro to neural nets

require(MASS)
require(nnet)

tst <- nnet(1000/MPG.city ~ Weight+Origin+Type,
  Cars93, linout = T, size = 0, decay = 0, rang = 0,
  skip = T, trace = T)
  
coef(tst)

tst1 <- lm(1000/MPG.city ~ Weight + Origin+Type, Cars93)
coef(tst1)

range(coef(tst) - coef(tst1))

tst <- nnet(low ~ ptd + ftv/age, data = bwt, entropy = TRUE,
    skip = TRUE, size = 0, decay = 0, rang = 0, trace = TRUE)

tst1 <- glm(low ~ ptd + ftv/age, binomial, bwt)
range(coef(tst) - coef(tst1))

set.seed(20109)  # nothing special
sb1 <- sample(1:nrow(bwt), 100)
bwt.train <- bwt[sb1,  ]
bwt.test <- bwt[ - sb1,  ]
bm.train <- update(tst1, data = bwt.train)
bm.tst <- predict(bm.train, bwt.test, type = "resp")
bm.class <- round(bm.tst)
table(bm.class, bwt.test$low)


require(tree)
tm.train <- tree(factor(low) ~ race + smoke + age +
                ptd + ht + ui + ftv, bwt.train)
plot(cv.tree(tm.train, FUN = prune.misclass))
tm.train <- prune.tree(tm.train, best = 4)
tm.class <- predict(tm.train, bwt.test, type = "class")
table(tm.class, bwt.test$low)

X0 <- max(abs(model.matrix( ~ race + smoke + age +
          ptd + ht + ui + ftv, bwt.train)))

nm.train <- nnet(low ~ race + smoke + age + ptd +
    ht + ui + ftv, data = bwt.train, size = 3, entropy = T,
    rang = 1/X0, skip = T, decay = 0.01, trace = T, maxit = 1000)

nm.tst <- predict(nm.train, newdata = bwt.test, type = "raw")
nm.class <- round(nm.tst)
table(nm.class, bwt.test$low)

###

CC.nnet <- nnet(credit.card.owner ~ ., CCTrain, size = 7,
  rang = 2e-7, skip = T, decay = 0.05, trace = T, maxit = 1000)

testPred2(CC.nnet)


