  Species <- scan("SpeciesNames.txt", what = "")

match(Species, names(Benthos))

bin <- function(fac, all = F) {
#
# binary matrix for a factor
#
	fac <- as.factor(fac)
	X <- outer(fac, levels(fac), "==") + 0
	dimnames(X) <- list(NULL, levels(fac))
	if(all) X else X[, -1]
}
nsi <- function(x, k = 3, Intensity = Benthos$Intensity) {
#
# natural spline in intensity
#
  knots <- as.vector(quantile(unique(Intensity), 0:k/k))
  ns(x, knots = knots[2:k], Boundary.knots = knots[c(1, k + 1)])
}

guard <- function(x) ifelse(x < -5, NA, x)

####

vars <- c("Cruise", "Plot", "Months", "Treatment",
          "Time", "Impact", "Topography", "Unity")
vals <- with(Benthos, tapply(Intensity, Impact, mean))
msa <- mean(Benthos$SweptArea)

newData <- transform(Benthos[, vars],
  Months = as.numeric(as.character(Months)),
  Intensity = vals[factor(Impact)],
  SweptArea = rep(msa, nrow(Benthos)))

newData <- newData[order(Benthos$Months), ]

####

fitCommand <- Quote({
fm <- glmmPQL(Species ~ Topography +
	I(Impact * cbind(nsi(Intensity), bin(Time))) +
	offset(log(SweptArea)),
	random = ~1|Cruise/Plot,
	family = poisson, data = Benthos, verbose = T)

 ### work-around for bug in summary.
b <- names(fm$coefficients$fixed)
names(fm$coefficients$fixed) <- paste(b, seq(along = b))
})

#####

spno <- 1

### --- start of main loop

mname <- paste("GLMM", Species[spno], sep=".")
sname <- Species[spno]
thisFitCommand <- do.call("substitute", list(fitCommand,
	list(fm = as.name(mname), Species = as.name(sname))))

eval(thisFitCommand)
print(spno <- spno + 1)

### --- end of main loop
objects(pat = "GLMM.*")

Store(objects(pat = "GLMM.*"))

#####

pfm <- predict(GLMM.Alcyonacea, newData) + log(msa)
pfm0 <- predict(GLMM.Alcyonacea, newData, level=0) + log(msa)
graphics.off()

trellis.device()
xyplot(guard(pfm) ~ Months|Treatment*Topography, newData,
  groups = Plot, type="b",
	main = "Alcyonacea", ylab = "log(mean)",
	sub = "fixed and random effects")


xyplot(exp(pfm0) ~ Months|Treatment*Topography, newData,
  groups = Plot, type="b",
	main = "Alcyonacea", ylab = "mean",
	sub = "fixed effects only")

###

summary(GLMM.Alcyonacea, corr = F)

################
xyplot(log(Length) ~ Conc | Strip, muscle, as.table = T,
    xlab = "CaCl concentration")



X <- model.matrix(~Strip - 1, muscle)

muscle.nls1 <- nls(log(Length) ~ cbind(X, X*rho^Conc),
  muscle, start = c(rho = 0.1), algorithm = "plinear",
  trace = T)

b <- as.vector(coef(muscle.nls1))

init <- list(rho = b[1],
	alpha = b[2:22], beta = b[23:43])
muscle.nls2 <- nls(log(Length) ~ alpha[Strip] +
  beta[Strip]*rho^Conc, muscle, start = init, trace = T)
####

Muscle <- expand.grid(Conc = seq(0.25, 4, len=20),
		Strip = levels(muscle$Strip), Length = 0)
Muscle <- rbind(muscle, Muscle)
Muscle <- Muscle[order(Muscle$Strip, Muscle$Conc), ]
Muscle$fit <- predict(muscle.nls2, Muscle)

xyplot(fit ~ Conc|Strip, Muscle, type = "l", subscripts = T,
panel = function(x, y, subscripts, ...) {
	panel.xyplot(x, y, ...)
	panel.points(x, log(Muscle$Length[subscripts]))
}, as.table = T, ylab = "log(Length)",
	xlab = "CaCl concentration")

###

ival <- sapply(init, mean)

muscle.nlme <- nlme(log(Length) ~ alpha + beta*rho^Conc, muscle,
  fixed = rho+alpha+beta ~ 1,
  random = alpha + beta ~ 1|Strip,
  start = ival)

Muscle$RandomFit <- predict(muscle.nlme, Muscle)

xyplot(RandomFit ~ Conc|Strip, Muscle, type = "l",
	subscripts = T,
panel = function(x, y, subscripts, ...) {
	panel.xyplot(x, y, ...)
	panel.lines(x, Muscle$fit[subscripts], col = "red")
	panel.points(x, log(Muscle$Length[subscripts]))
}, as.table = T, ylab = "log(Length)",
		xlab = "CaCl concentration")
###

summary(muscle.nlme)
