### scripts for Session 01, Modelling with R

jpeg(filename = "Session_01_%03d.jpg", width=800, height = 650)

with(janka, plot(Density, Hardness,
	xlim = range(0, Density), ylim = range(0, Hardness),
	las=0))

jank.1 <- lm(Hardness ~ Density, janka)
jank.2 <- update(jank.1, .~.+I(Density^2))
jank.3 <- update(jank.2, .~.+I(Density^3))

Janka <- rbind(janka[, c("Density", "Hardness")],
	data.frame(Density = seq(0, 70, length=200),
			Hardness = NA))

Janka <- Janka[order(Janka$Density), ]  # ordered densities
Janka <- transform(Janka,
			p1 = predict(jank.1, Janka),
			p2 = predict(jank.2, Janka),
			p3 = predict(jank.3, Janka))

with(Janka, {
	rg <- range(Hardness, p1, p2, p3, na.rm = T)
	plot(Density, Hardness, ylim = rg)
	lines(Density, p1, col="red")
	lines(Density, p2, col="blue")
	lines(Density, p3, col="green4")
	legend(0, 3000, paste("p", 1:3, sep=""),
	lty = 1, col = c("red", "blue", "green4"),
	bty = "n")
})

x <- c(mean(janka$Hard), coef(jank.1), 				coef(jank.2), coef(jank.3))
w <- matrix(0, 4, 4)
w[!lower.tri(w)] <- x
dimnames(w) <- list(paste("Degree", 0:3), 				paste("Model", 0:3))
round(t(w), 5)


janka$d <- scale(janka$Density, scale=F)
jank.1a <- lm(Hardness ~ d, janka)
jank.2a <- update(jank.1a, .~.+I(d^2))
jank.3a <- update(jank.2a, .~.+I(d^3))
range(fitted(jank.3a) - fitted(jank.3)) # check
# _[1] -4.547474e-13  4.547474e-13


x <- c(mean(janka$Hard), coef(jank.1a), coef(jank.2a), 		coef(jank.3a))
w[!lower.tri(w)] <- x
round(t(w), 5)

janka <- transform(janka,
		  FittedValue = fitted(jank.2),
		  Residual = resid(jank.2))

g1 <- xyplot(Residual ~ FittedValue, janka,
	panel = function(x, y, ...) {
		panel.xyplot(x, y, col = "blue", ...)
		panel.abline(h = 0,
			lty = "dashed", col = "red")
	}, las = 0)
g2 <- qqmath(~Residual, janka,
	panel = function(x, y, ...) {
		panel.qqmath(x, ...)
		panel.qqmathline(x, x, distribution = qnorm,
			col = "red", lty = "solid")
	}, las = 0)

print(g1, position = c(0, 0.45, 0.55, 1), more = T)
print(g2, position = c(0.45, 0, 1, 0.55))

library(MASS)
par(mfrow = c(2,2))
boxcox(jank.1, lambda = seq(0, 0.75, len=10))
title(main = "Linear")
jank.1t <- update(jank.1, sqrt(.) ~ .)
plot(fitted(jank.1t), resid(jank.1t), main = "Linear")
abline(h = 0, lty="dashed", col="blue")

boxcox(jank.2, lambda = seq(-0.25, 0.6, len=10))
title(main = "Quadratic")
jank.2t <- update(jank.2, log(.) ~ .)
plot(fitted(jank.2t), resid(jank.2t), main = "Quadratic")
abline(h = 0, lty="dashed", col="blue")

janka2 <- with(janka,
	data.frame(Density =
	seq(min(Density), max(Density), len=200)))

pjank.2t <- predict(jank.2t, new = janka2, se=T)
tau <- qt(0.975, 36 - 3)

janka2 <- with(pjank.2t,
	transform(janka2,
		mean = fit,
		lo = fit - tau*se.fit,
 		up = fit + tau*se.fit))
bias.corr <- 0.5*sum(resid(jank.2t)^2)/pjank.2t$df

janka2 <- transform(janka2,
	Hardness = exp(mean + bias.corr),
	upper = exp(up + bias.corr),
	lower = exp(lo + bias.corr))
rg <- with(janka2,
	range(Hardness, lower, upper, janka$Hardness))

with(janka2, {
	par(mfrow=c(1,1))
	plot(Density, Hardness, type = "l", ylim = rg)
	lines(Density, upper, lty=4, col=3)
	lines(Density, lower, lty=4, col=3)
})
with(janka, points(Density, Hardness))

jank.glm <- glm(Hardness ~ Density, family =
		quasi(link = sqrt, variance = "mu^2"), janka, trace = T)
# _Deviance = 0.3335429 Iterations - 1
# _Deviance = 0.3287643 Iterations - 2
# _Deviance = 0.3287642 Iterations - 3
# _Deviance = 0.3287642 Iterations - 4

pjank.glm <- predict(jank.glm, newdata = janka2, se.fit = T)

janka3 <- with(pjank.glm,
  transform(janka2, Hardness = fit^2,
                    lower = (fit - 2*se.fit)^2,
                    upper = (fit+2*se.fit)^2))

rg <- with(janka3, range(lower, upper, janka$Hardness))

par(mfrow=c(1,1))
with(janka3, {
	plot(Density, Hardness, type = "l", ylim = rg)
	lines(Density, upper, lty=4, col=3)
	lines(Density, lower, lty=4, col=3)
})
with(janka, points(Density, Hardness))

pjank.2 <- predict(jank.2, new = janka2, se=T)
tau <- qt(0.975, 36 - 3)

janka2 <- with(pjank.2,
	transform(janka2,
		Hardness = fit,
		upper = fit + tau*se.fit,
		lower = fit-tau*se.fit))

rg <- with(janka2, range(lower, upper, janka$Hard))
with(janka2, {
	par(mfrow=c(1,1))
	plot(Density, Hardness, type = "l", ylim = rg)
	lines(Density, upper, lty=4, col=3)
	lines(Density, lower, lty=4, col=3)
})
with(janka, points(Density, Hardness))

dev.off()
