
### the 'plinear' algorithm

wtloss.plin <- nls(Weight ~ cbind(1, 2^(-Days/tau)), wtloss,
  start = c(tau = 140), trace = T, algorithm = "plinear")

coef(wtloss.plin)

###

storm.plin <- nls(Time ~ Viscosity/(Wt - theta), stormer,
  start = c(theta = 2), trace = T, algorithm = "plinear")

coef(storm.plin)

###

xyplot(log(Length) ~ Conc | Strip, muscle, as.table = T)

X <- with(muscle, outer(Strip, levels(Strip), "==")+0)

muscle.plin <- nls(log(Length) ~ cbind(X, X*rho^Conc), muscle,
  start = c(rho = 0.05), algorithm = "plinear", trace = T)

cf <- as.vector(coef(muscle.plin))
sv <- list(a = cf[2:22], b = cf[23:43], rho = cf[1]) # must be a list

muscle.fact <- nls(log(Length) ~ a[Strip] + b[Strip]*rho^Conc, muscle,
  start = sv, trace = T)  # NOT plinear, now

pMuscle <- with(muscle, expand.grid(Strip = levels(Strip),
                    Conc = seq(0.25, 4, len = 50), Length = NA))
pMuscle <- rbind(muscle, pMuscle)
pMuscle <- transform(pMuscle,
            pLength = exp(predict(muscle.fact, pMuscle)))
pMuscle <- with(pMuscle, pMuscle[order(Strip, Conc), ])

yl <- log(range(muscle$Length, pMuscle$pLength))

xyplot(log(Length) ~ Conc | Strip, pMuscle, as.table = T,
  ylim = yl, subscripts = T, panel = function(x, y, subscripts, ...) {
    panel.xyplot(x, y, ...)
    with(pMuscle, panel.lines(x, log(pLength[subscripts]), col = "red"))
    })

### Soil water retention example


cra <- transform(read.csv("http://www.leg.ufpr.br/~paulojus/aulasR/dados/cra.csv"),
                  am = factor(am))

fm2 <- nls(u ~ ur[am] + (us[am] -ur[am])*(1/(1+(alpha[am]*pot)^n[am]))^(1-1/n[am]), cra,
  start = list(us=c(0.3,0.24), ur = c(0,-0.1), alpha=c(0.038, 0.038), n = c(1.11, 1.21)),
  trace = T)

fm1 <- nls(u ~ ur[am] + (us[am] -ur[am])*(1/(1+(alpha*pot)^n))^(1-1/n), cra,
  start = list(us=c(0.3,0.24), ur = c(0,-0.1), alpha=0.038, n = 1.21),
  trace = T)

anova(fm1, fm2)

  