## Data for the headrope project for the NPF

load("Records.RData")

Records<-read.csv("../CSV/Records.csv")


require(Matrix)
require(lme4)

NPF_1 <- lmer2(log(Catch) ~ log(Days) + LHead +LHull +LPower +
            Stock + (1|VCode/YearF) + (1|YearF/Stock),
            data = Records, subset = Stock != "Tig1")

summary(NPF_1)


NPF_1A <- lmer2(log(Catch/Days) ~ log(Days) + LHead +LHull +LPower +
            Stock + (1|VCode/YearF) + (1|YearF/Stock),
            data = Records, subset = Stock != "Tig1")
summary(NPF_1A)

g <- fixef(NPF_1A)["LHead"]
dH <- seq(-1, 1.5, len = 1000)
dC <- (1+dH)^g - 1

plot(dH, dC, type = "l", axes = FALSE,
  ann = FALSE, col = "red")
grid()
text(0.1, 0.2, expression(Delta*C))
text(1.45, 0.05, expression(Delta*H))
axis(1, pos = 0, cex.axis = 0.75)
axis(2, pos = 0, cex.axis = 0.75, las = 2)


