### milk protein data from Diggle, Liang, Zeger

require(nlme)
data(Milk, package = "nlme")

#> names(Milk)
#[1] "protein" "Time"    "Cow"     "Diet"

## look at the data
#> length(levels(Milk$Cow))
#[1] 79

Milk <- transform(Milk, Cow = factor(as.character(Cow)))  # optional

jpeg(filename = "MilkProtein_%03d.jpg", height = 1200, width = 1200)
xyplot(protein ~ Time | Cow, Milk, as.table = TRUE,
  panel = function(x, y, ...) {
    panel.xyplot(x, y, ...)
    panel.lmline(x, y, ..., col = "navy")
  }, layout = c(5, 5, 4))
dev.off()

### test models

MP_1 <- lme(protein ~ Diet*Time, random = ~1+Time | Cow,
            data = Milk)
MP_2 <- update(MP_1, .~Diet + Time)

anova(MP_2, MP_1)

### heed warning and correct mistake

MP_1 <- lme(protein ~ Diet*Time, random = ~1+Time | Cow,
            data = Milk, method = "ML")
MP_2 <- update(MP_1, .~Diet + Time, method = "ML")

MP_3 <- update(MP_2, .~Time)

anova(MP_3, MP_2, MP_1)

MP_2 <- update(MP_2, method = "REML")

summary(MP_2)

ranef(MP_2)

## exercise: show the predicted lines on the plot, both including blups and level 0.

### A quadratic extension

MP_4 <- lme(protein ~ Diet*poly(Time, 2), random = ~poly(Time, 2)|Cow,
          data = Milk, method = "ML")
MP_5 <- update(MP_4, .~Diet + poly(Time, 2))
MP_6 <- update(MP_4, .~Diet)

anova(MP_6, MP_5, MP_4)

MP_2 <- update(MP_2, method = "ML")
anova(MP_2, MP_5)



tmp <- cbind(Milk, fMP2 = fitted(MP_2), fMP5 = fitted(MP_5))
tmp <- with(tmp, tmp[order(Cow, Time), ])

jpeg(filename = "MilkProtein_2_%03d.jpg", height = 1200, width = 1200)
xyplot(protein ~ Time | Cow, tmp, subscripts = TRUE, as.table = TRUE,
  panel = function(x, y, subscripts, ...) {
    panel.xyplot(x, y, ...)
    panel.lines(x, tmp$fMP2[subscripts], col = "navy")
    panel.lines(x, tmp$fMP5[subscripts], col = "red")
  }, layout = c(5, 5, 4))
dev.off()

MP_5_REML <- update(MP_5, method = "REML")

summary(MP_5_REML)

