# Average daily fat yields (kg/day) from milk
# from a single cow for each of 35 weeks
# McCulloch (2001)
# Ruppert, Cressie, Carroll (1989) - Biometrics, 45: 637-656

Milk <- data.frame(week = 1:35, yield = scan())
0.31 0.39 0.50 0.58 0.59 0.64
0.68 0.66 0.67 0.70 0.72 0.68
0.65 0.64 0.57 0.48 0.46 0.45
0.31 0.33 0.36 0.30 0.26 0.34
0.29 0.31 0.29 0.20 0.15 0.18
0.11 0.07 0.06 0.01 0.01

### display the data

with(Milk,
  plot(week, yield, pch = 8, cex = 0.8, xlab = "Week",
    ylab = "Fat yield (kg/day)")
)

### standard and log-link model

M1 <- lm(log(yield) ~ week + log(week), Milk)
M2 <- glm(yield ~ week + log(week), quasi(link = "log"), Milk)

### generalized additive model competitors

require(mgcv)
M3 <- gam(log(yield) ~ s(week), gaussian, Milk)
M4 <- gam(yield ~ s(week), quasi(link = "log"), Milk)

### predictions for a fine-grid time scale

pMilk <- data.frame(week = seq(1, 35, by = 0.1))
pMilk <- transform(pMilk, pM1 = exp(predict(M1, pMilk)),
                          pM2 = predict(M2, pMilk, type="resp"),
                          pM3 = exp(predict(M3, pMilk)),
                          pM4 = predict(M4, pMilk, type="response"))
                          
yl <- range(Milk$yield, with(pMilk, range(pM1, pM2, pM3, pM4))) # for plotting

### display the results

with(Milk,
  plot(week, yield, pch = 8, cex = 0.8, xlab = "Week",
    ylab = "Fat yield (kg/day)", ylim = yl,
    col = "navy")
)

with(pMilk, {
  lines(week, pM1, col = "red")
  lines(week, pM2, col = "green4")
  lines(week, pM3, col = "red", lty = "dashed")
  lines(week, pM4, col = "green4", lty = "dashed")
})

legend("topright",
  c("observed", "lm, log-transformed", "glm, log-link",
               "gam, log-transformed", "gam, log-link"),
  lty = c(NA, "solid", "solid", "dashed", "dashed"),
  pch = c(8, NA, NA, NA, NA),
  col = c("navy", "red", "green4", "red", "green4"),
  cex = 0.8, bty = "n")
