### The Florida vote data - an American scandal

Attach()  ##

#> names(Florida)
#[1] "County"    "Candidate" "Vote"      "Total"

FV <- glmmPQL(Vote/Total ~ Candidate, random =  ~1|County/Candidate,
      family = binomial, data = Florida, weights = Total)


summary(FV)

rf <- ranef(FV)[[2]]

nam <- do.call("rbind", strsplit(row.names(rf), "/"))

PB <- t(matrix(rf[,1], nrow = 2))[, 2:1]
dimnames(PB) <- list(unique(nam[,1]), rev(unique(nam[, 2])))

plot(PB)
identify(PB[,1], PB[,2], row.names(PB))
