###################################################
### chunk number 1: c1
###################################################
rats <- read.csv("rat_data.csv")
rats.m1 <- 
  nls(y ~ alpha + delta*log(x1 + rho*x2 + kappa*sqrt(rho*x1*x2)),
    data = rats, start = c(alpha = -17, delta = 10, rho = 0.05,
                           kappa = -0.03), trace = TRUE)
summary(rats.m1)


###################################################
### chunk number 2: c2
###################################################
rs <- resid(rats.m1)
fv <- fitted(rats.m1)
par(mfrow=c(1,2))
plot(fv, rs, xlab = 'Fitted', ylab = 'Residuals', col = 'red')
abline(h = 0, col = 'navy', lty = 'dashed')
qqnorm(rs, main = '', col = 'red')
qqline(rs, col = 'navy', lty = 'dashed')


###################################################
### chunk number 3: c3
###################################################
b1 <- coef(rats.m1)
rats.m2 <- 
  nls(y ~ alpha + delta*log(x1 + rho*x2 + kappa*sqrt(x1*x2)),
    data = rats, start = b1, trace = TRUE)
summary(rats.m2)
b2 <- coef(rats.m2)
c(b2["kappa"], b1["kappa"]*sqrt(b1["rho"]))


###################################################
### chunk number 4: c4
###################################################
feijao <- read.csv("bean_data.csv")
with(feijao, plot(x, y, pch=8, cex = 0.7, xlab = "Amount of water",
                  ylab = "Length", ylim = c(0,22)))
pFei <- with(feijao, data.frame(x = seq(min(x), max(x), len = 1000)))
fei.gz <- nls(y ~ SSgompertz(x, alpha, beta, gamma), feijao)
fei.lo <- nls(y ~ SSlogis(x, alpha, beta, gamma), feijao)
pFei.gz <- predict(fei.gz, pFei)
pFei.lo <- predict(fei.lo, pFei)
with(pFei, {
  lines(x, pFei.gz, col = "navy")
  lines(x, pFei.lo, col = "red")
})
bstart <- c(delta = 0, coef(fei.gz))
fei.gz1 <- nls(y ~ delta + alpha*exp(-beta*gamma^x),
           data = feijao, start = bstart, trace = TRUE)
bstart <- c(delta = 0, coef(fei.lo))
fei.lo1 <- nls(y ~ delta + alpha/(1 + exp(-(x - beta)/gamma)),
           data = feijao, start = bstart, trace = TRUE)
pFei.gz1 <- predict(fei.gz1, pFei)
pFei.lo1 <- predict(fei.lo1, pFei)
with(pFei, {
  lines(x, pFei.gz1, col = "navy", lty = "dashed")
  lines(x, pFei.lo1, col = "red", lty = "dashed")
})
legend("bottomright", c("Observations", "Gompertz", "Logistic",
"delta + Gompertz", "delta + Logistic"),
pch = c(8, rep(NA, 4)),
lty = c(NA, rep(c("solid", "dashed"), each = 2)),
col = c("black", rep(c("navy", "red"), 2)), bty = "n", cex = 0.7)


###################################################
### chunk number 5: c5
###################################################
anova(fei.gz, fei.gz1)
anova(fei.lo, fei.lo1)


