### Exercise 1, a solution

# _> names(Birthwt)
# _[1] "sex" "age" "wt"

m1 <- aov(wt ~ sex/poly(age, 2), Birthwt)
m2 <- aov(wt ~ sex/age, Birthwt)
m3 <- aov(wt ~ age + sex, Birthwt)
m4 <- aov(wt ~ age, Birthwt)

anova(m4, m3, m2, m1)

# _Analysis of Variance Table
# _
# _Model 1: wt ~ age
# _Model 2: wt ~ age + sex
# _Model 3: wt ~ sex/age
# _Model 4: wt ~ sex/poly(age, 2)
# _  Res.Df    RSS Df Sum of Sq      F  Pr(>F)
# _1     22 816074
# _2     21 658771  1    157304 4.6782 0.04425
# _3     20 652425  1      6346 0.1887 0.66913
# _4     18 605246  2     47179 0.7015 0.50888

# _model m3 seems to be the most complex model required.
# _Check each term separately:

dropterm(m3, test = "F")
# _Single term deletions
# _
# _Model:
# _wt ~ age + sex
# _       Df Sum of Sq     RSS     AIC F Value     Pr(F)
# _<none>               658771     251
# _age     1   1094940 1753711     273      35 7.284e-06
# _sex     1    157304  816074     254       5   0.03609

# _We need both sex and age terms, but no interactins or
# _quadratic terms.
# _
# _Now for some diagnostic checks:

fv <- fitted(m3)
rs <- resid(m3)

par(mfrow = c(2,2))
plot(fv, rs, col = "navy", cex = 0.5)
abline(h = 0, col = "red", lty = "dashed")

qqnorm(rs, col = "navy", cex = 0.5)
qqline(rs, col = "red", lty = "dashed")

# _With a small sample, diagnostic checks are not
# _very effective, but these give no clear indication
# _of problems.
# _
# _Retain wt ~ age + sex, parallel regressions with
# _females slightly, but significantly, lighter than
# _males at the same gestational age.
