# -*- mode: sh -*- ###########################
# Qwt Widget Library
# Copyright (C) 1997   Josef Wilgen
# Copyright (C) 2002   Uwe Rathmann
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the Qwt License, Version 1.0
##############################################

# pro file for building the makefile for qwt
#
# Please read the instructions in INSTALL, if you don�t know
# how to use it.
#
# HEADERS/SOURCES are separated into plot
# relevant files and others. If you are 
# interested in QwtPlot only, you can remove
# the lists at the end of this file.

TARGET            = qwt
TEMPLATE          = lib

VERSION      = 5.0.0

# Only one of the following flags is allowed !
CONFIG           += qt
#CONFIG           += qtopia

CONFIG           += thread
CONFIG           += warn_off 
#CONFIG           += release

# Only one of the following flags is allowed !
CONFIG           += dll 
# CONFIG           += staticlib

# DEFINES          += QT_NO_CAST_ASCII
# DEFINES          += QT_NO_CAST_TO_ASCII

win32 {
MOC_DIR           = moc
OBJECTS_DIR       = Release
DESTDIR           = Release
}

unix {
MOC_DIR           = .moc
#OBJECTS_DIR       = .obj
#DESTDIR           = ../lib
}

INCLUDEPATH      += ../../src/qwt/include
DEPENDPATH       += ../../src/qwt/include ../../src/qwt

win32:dll:DEFINES    += QT_DLL QWT_DLL QWT_MAKEDLL

isEmpty(TE_PROJECT_TYPE) {
  TE_PROJECT_TYPE=RELEASE
}

contains(TE_PROJECT_TYPE , DEBUG) {
  CONFIG -= release
  CONFIG += debug
}

contains(TE_PROJECT_TYPE , RELEASE) {
  CONFIG += release
}

unix {

  debug {
    DEFINES += _DEBUG
    OBJECTS_DIR = ../Debug/.obj/qwt
    DESTDIR = ../Debug
  }
  release {
    DEFINES += NDEBUG
    OBJECTS_DIR = ../Release/.obj/qwt
    DESTDIR = ../Release
  }
}

HEADERS = \
    ../../src/qwt/include/qwt.h \
    ../../src/qwt/include/qwt_abstract_scale_draw.h \
    ../../src/qwt/include/qwt_array.h \
    ../../src/qwt/include/qwt_data.h \
    ../../src/qwt/include/qwt_double_interval.h \
    ../../src/qwt/include/qwt_double_rect.h \
    ../../src/qwt/include/qwt_dyngrid_layout.h \
    ../../src/qwt/include/qwt_event_pattern.h \
    ../../src/qwt/include/qwt_global.h \
    ../../src/qwt/include/qwt_interval_data.h \
    ../../src/qwt/include/qwt_layout_metrics.h \
    ../../src/qwt/include/qwt_legend.h \
    ../../src/qwt/include/qwt_legend_item.h \
    ../../src/qwt/include/qwt_math.h \
    ../../src/qwt/include/qwt_painter.h \
    ../../src/qwt/include/qwt_paint_buffer.h \
    ../../src/qwt/include/qwt_picker.h \
    ../../src/qwt/include/qwt_picker_machine.h \
    ../../src/qwt/include/qwt_plot.h \
    ../../src/qwt/include/qwt_plot_curve.h \
    ../../src/qwt/include/qwt_plot_dict.h \
    ../../src/qwt/include/qwt_plot_grid.h \
    ../../src/qwt/include/qwt_plot_layout.h \
    ../../src/qwt/include/qwt_plot_marker.h \
    ../../src/qwt/include/qwt_plot_printfilter.h \
    ../../src/qwt/include/qwt_plot_item.h \
    ../../src/qwt/include/qwt_plot_canvas.h \
    ../../src/qwt/include/qwt_plot_picker.h \
    ../../src/qwt/include/qwt_plot_zoomer.h \
    ../../src/qwt/include/qwt_rect.h \
    ../../src/qwt/include/qwt_round_scale_draw.h \
    ../../src/qwt/include/qwt_scale_widget.h \
    ../../src/qwt/include/qwt_scale_div.h \
    ../../src/qwt/include/qwt_scale_draw.h \
    ../../src/qwt/include/qwt_scale_engine.h \
    ../../src/qwt/include/qwt_scale_map.h \
    ../../src/qwt/include/qwt_spline.h \
    ../../src/qwt/include/qwt_symbol.h \
    ../../src/qwt/include/qwt_text_engine.h \
    ../../src/qwt/include/qwt_text_label.h \
    ../../src/qwt/include/qwt_text.h

SOURCES = \
    ../../src/qwt/qwt_abstract_scale_draw.cpp \
    ../../src/qwt/qwt_data.cpp \
    ../../src/qwt/qwt_double_interval.cpp \
    ../../src/qwt/qwt_double_rect.cpp \
    ../../src/qwt/qwt_dyngrid_layout.cpp \
    ../../src/qwt/qwt_event_pattern.cpp \
    ../../src/qwt/qwt_interval_data.cpp \
    ../../src/qwt/qwt_layout_metrics.cpp \
    ../../src/qwt/qwt_legend.cpp \
    ../../src/qwt/qwt_legend_item.cpp \
    ../../src/qwt/qwt_math.cpp \
    ../../src/qwt/qwt_painter.cpp \
    ../../src/qwt/qwt_paint_buffer.cpp \
    ../../src/qwt/qwt_picker.cpp \
    ../../src/qwt/qwt_picker_machine.cpp \
    ../../src/qwt/qwt_plot.cpp \
    ../../src/qwt/qwt_plot_axis.cpp \
    ../../src/qwt/qwt_plot_curve.cpp \
    ../../src/qwt/qwt_plot_dict.cpp \
    ../../src/qwt/qwt_plot_grid.cpp \
    ../../src/qwt/qwt_plot_item.cpp \
    ../../src/qwt/qwt_plot_print.cpp \
    ../../src/qwt/qwt_plot_marker.cpp \
    ../../src/qwt/qwt_plot_layout.cpp \
    ../../src/qwt/qwt_plot_printfilter.cpp \
    ../../src/qwt/qwt_plot_canvas.cpp \
    ../../src/qwt/qwt_plot_picker.cpp \
    ../../src/qwt/qwt_plot_zoomer.cpp \
    ../../src/qwt/qwt_rect.cpp \
    ../../src/qwt/qwt_round_scale_draw.cpp \
    ../../src/qwt/qwt_scale_widget.cpp \
    ../../src/qwt/qwt_scale_div.cpp \
    ../../src/qwt/qwt_scale_draw.cpp \
    ../../src/qwt/qwt_scale_engine.cpp \
    ../../src/qwt/qwt_scale_map.cpp \
    ../../src/qwt/qwt_spline.cpp \
    ../../src/qwt/qwt_symbol.cpp \
    ../../src/qwt/qwt_text_engine.cpp \
    ../../src/qwt/qwt_text_label.cpp \
    ../../src/qwt/qwt_text.cpp 
 
##############################################
# If you are interested in the plot widget
# only, you can remove the following 
# HEADERS/SOURCES lists.
##############################################

HEADERS += \
    ../../src/qwt/include/qwt_abstract_slider.h \
    ../../src/qwt/include/qwt_abstract_scale.h \
    ../../src/qwt/include/qwt_arrow_button.h \
    ../../src/qwt/include/qwt_analog_clock.h \
    ../../src/qwt/include/qwt_compass.h \
    ../../src/qwt/include/qwt_compass_rose.h \
    ../../src/qwt/include/qwt_counter.h \
    ../../src/qwt/include/qwt_dial.h \
    ../../src/qwt/include/qwt_dial_needle.h \
    ../../src/qwt/include/qwt_double_range.h \
    ../../src/qwt/include/qwt_knob.h \
    ../../src/qwt/include/qwt_slider.h \
    ../../src/qwt/include/qwt_thermo.h \
    ../../src/qwt/include/qwt_wheel.h

SOURCES += \
    ../../src/qwt/qwt_abstract_slider.cpp \
    ../../src/qwt/qwt_abstract_scale.cpp \
    ../../src/qwt/qwt_arrow_button.cpp \
    ../../src/qwt/qwt_analog_clock.cpp \
    ../../src/qwt/qwt_compass.cpp \
    ../../src/qwt/qwt_compass_rose.cpp \
    ../../src/qwt/qwt_counter.cpp \
    ../../src/qwt/qwt_dial.cpp \
    ../../src/qwt/qwt_dial_needle.cpp \
    ../../src/qwt/qwt_double_range.cpp \
    ../../src/qwt/qwt_knob.cpp \
    ../../src/qwt/qwt_slider.cpp \
    ../../src/qwt/qwt_thermo.cpp \
    ../../src/qwt/qwt_wheel.cpp
