#include "PluginParameters.h"


PluginParameters::PluginParameters()
{
  init();
}


PluginParameters::PluginParameters(
  QMainWindow* qtmain_widget_ptr,
  TeProgressBase* teprogressbase_ptr,
  TeQtDatabasesListView* teqtdatabaseslistview_ptr,
  TeQtViewsListView* teqtviewslistview_ptr,
  TeQtGrid* teqtgrid_ptr,
  TeQtCanvas* teqtcanvas_ptr,
  TeDatabase* current_database_ptr,
  TeLayer* current_layer_ptr,
  TeView* current_view_ptr,
  TeAppTheme* current_theme_ptr,
  TeCommunicator<PluginsSignal>* signal_emitter,
  getCurrentDatabasePtrFPT getCurrentDatabasePtrFP,
  getCurrentLayerPtrFPT getCurrentLayerPtrFP,
  getCurrentViewPtrFPT getCurrentViewPtrFP,
  getCurrentThemeAppPtrFPT getCurrentThemeAppPtrFP,
  setCurrentThemeAppPtrFPT setCurrentThemeAppPtrFP,
  updateTVInterfaceFPT updateTVInterfaceFP,
  loadTranslationFileFPT loadTranslationFileFP,
  updatePluginParametersFPT updatePluginParametersFP
  )
{
  init();

  qtmain_widget_ptr_ = qtmain_widget_ptr;
  teprogressbase_ptr_ = teprogressbase_ptr;
  teqtdatabaseslistview_ptr_ = teqtdatabaseslistview_ptr;
  teqtviewslistview_ptr_ = teqtviewslistview_ptr;
  teqtgrid_ptr_ = teqtgrid_ptr;
  teqtcanvas_ptr_ = teqtcanvas_ptr;
  signal_emitter_ = signal_emitter;
  
	getCurrentDatabasePtrFP_ = getCurrentDatabasePtrFP;
	getCurrentLayerPtrFP_ = getCurrentLayerPtrFP;
	getCurrentViewPtrFP_ = getCurrentViewPtrFP;
	getCurrentThemeAppPtrFP_ = getCurrentThemeAppPtrFP;
	setCurrentThemeAppPtrFP_ = setCurrentThemeAppPtrFP;
	updateTVInterfaceFP_ = updateTVInterfaceFP;
	loadTranslationFileFP_ = loadTranslationFileFP;
	
	/* The following variables are DEPRECATED */
	
  current_database_ptr_ = current_database_ptr;
  current_layer_ptr_ = current_layer_ptr;
  current_view_ptr_ = current_view_ptr;
  current_theme_ptr_ = current_theme_ptr;
  updatePluginParametersFP_ = updatePluginParametersFP;	
}   
        

PluginParameters::~PluginParameters()
{
}


void PluginParameters::init()
{
  qtmain_widget_ptr_ = 0;
  teprogressbase_ptr_ = 0;
  teqtdatabaseslistview_ptr_ = 0;
  teqtviewslistview_ptr_ = 0;
  teqtgrid_ptr_ = 0;
  teqtcanvas_ptr_ = 0;
  signal_emitter_ = 0;
  
	getCurrentDatabasePtrFP_ = 0;
	getCurrentLayerPtrFP_ = 0;
	getCurrentViewPtrFP_ = 0;
	getCurrentThemeAppPtrFP_ = 0;
	setCurrentThemeAppPtrFP_ = 0;
	updateTVInterfaceFP_ = 0;
	loadTranslationFileFP_ = 0;
	
	/* The following variables are DEPRECATED */
	
  current_database_ptr_ = 0;
  current_layer_ptr_ =0;
  current_view_ptr_ =0;
  current_theme_ptr_ =0;
  updatePluginParametersFP_ = 0;	
}


TeDatabase* PluginParameters::getCurrentDatabasePtr() const
{
  if( getCurrentDatabasePtrFP_ ) {
    return ( getCurrentDatabasePtrFP_( *this ) );
  } else {
    return 0;
  }
}


TeLayer* PluginParameters::getCurrentLayerPtr() const
{
  if( getCurrentLayerPtrFP_ ) {
    return ( getCurrentLayerPtrFP_( *this ) );
  } else {
    return 0;
  }
}


TeView* PluginParameters::getCurrentViewPtr() const
{
  if( getCurrentViewPtrFP_ ) {
    return ( getCurrentViewPtrFP_( *this ) );
  } else {
    return 0;
  }
}


TeAppTheme* PluginParameters::getCurrentThemeAppPtr() const
{
  if( getCurrentThemeAppPtrFP_ ) {
    return ( getCurrentThemeAppPtrFP_( *this ) );
  } else {
    return 0;
  }
}

void PluginParameters::setCurrentThemeAppPtr(TeAppTheme* appTheme)
{
  if( setCurrentThemeAppPtrFP_ ) {
    ( setCurrentThemeAppPtrFP_( appTheme, *this ) );
  }
}


void PluginParameters::updateTVInterface( const PluginParameters& ) const
{
  if( updateTVInterfaceFP_ ) {
    updateTVInterfaceFP_( *this );
  }
}

void PluginParameters::updateTVInterface() const
{
  if( updateTVInterfaceFP_ ) {
    updateTVInterfaceFP_( *this );
  }
}


bool PluginParameters::loadTranslationFile( const PluginParameters&,
  const std::string& filename ) const
{
  if( loadTranslationFileFP_ ) {
    return loadTranslationFileFP_( *this, filename );
  } else {
    return false;
  }
}


bool PluginParameters::loadTranslationFile( const std::string& filename ) const
{
  if( loadTranslationFileFP_ ) {
    return loadTranslationFileFP_( *this, filename );
  } else {
    return false;
  }
}


void PluginParameters::updatePluginParameters( PluginParameters& pp ) const
{
  if( updatePluginParametersFP_ ) {
    updatePluginParametersFP_( pp );
  }
}

