#include "TePDIFusion.hpp"
#include "TePDIStrategyFactory.hpp"
#include <TeAgnostic.h>


TePDIFusion::TePDIFusion()
{
}


TePDIFusion::~TePDIFusion()
{
}


void TePDIFusion::ResetState( const TePDIParameters& params )
{
  TePDIParameters dummy_params = params;
}


bool TePDIFusion::CheckParameters( const TePDIParameters& parameters ) const
{
  std::string fusion_type;
  TEAGN_TRUE_OR_RETURN( parameters.GetParameter( "fusion_type", fusion_type ),
    "Missing parameter : fusion_type" );

  TePDIStrategy::pointer fusion_strategy(  
    TePDIStrategyFactory::make( fusion_type, parameters ) );
    
  TEAGN_TRUE_OR_RETURN( fusion_strategy.isActive(), "Invalid strategy" );
  
  return fusion_strategy->CheckParameters( parameters );
}


bool TePDIFusion::RunImplementation()
{
  std::string fusion_type;
  TEAGN_TRUE_OR_RETURN( params_.GetParameter( "fusion_type", fusion_type ),
    "Missing parameter : fusion_type" );
    
  TePDIStrategy::pointer fusion_strategy(  
    TePDIStrategyFactory::make( fusion_type, params_ ) );
    
  TEAGN_TRUE_OR_RETURN( fusion_strategy.isActive(), "Invalid strategy" );
  
  return fusion_strategy->Apply( params_ );
}


