#' @title Teste Massivo de Modelos de Regressão Linear
#'
#' @name massive
#'
#' @author Daniel Ikenaga <daniel@@concatenando.com>
#'
#' @description Teste Massivo de Modelos de Regressão Linear
#'
#' @return Porcentagem de Acertors
#' @return Modelos
#' @return Coeficientes
#' @return AIC dos Modelos de Regressão
#'
#' @examples
#'
#' data(wine)
#' base <- wine[1:500,]
#' test <- massive(base)
#'
#' @export

massive <- function(base, preditor = 'ultimo', percent = 10, seed = 489850){
    set.seed(seed)
    if(preditor != 'ultimo'){
      if(ncol(base) != preditor){
        base[ncol(base) + 1] <- base[,preditor]
        base <- base[,-preditor]
      }
    }
    colnames(base)[ncol(base)] <- 'predict'
    total <- nrow(base)
    totaltest <- floor(total * (percent / 100))
    testrow <- sample(1:total, totaltest)
    test <- base[testrow,]
    train <- base[-testrow,]
    var <- ncol(test) - 1
    binvar <- 50 # 2^var - 1
    coef <- vector("list", 4)
    names(coef) <- c("coef", "model", "aic", "pacertos")
    coef$coef <- coef$model <- coef$aic <- coef$pacertos <- c(rep(0, binvar))
    for(i in 1:binvar){
      b <- c(rev(as.numeric(intToBits(i))[1:var]) == 1, TRUE)
      rlm <- lm(predict ~. ,data= test[,c(names(test)[c(b)])])
      coef$coef[i] <- list(rlm$coefficients)
      coef$model[i] <- list(b)
      coef$aic[i] <- AIC(rlm)
      train.p <- train[,unlist(coef$model[i])]
      preditor <- c(rep(0,dim(train.p)[1]))
      beta <- rlm$coefficients
      for(j in 1:dim(train.p)[1]){
        preditor[j] <- beta[1] + sum(train.p[j,-dim(train.p)[2]] * beta[-1])
      }
      p.df <- data.frame(cbind(train.p[dim(train.p)[2]],preditor))
      res <- abs(p.df[,1] - p.df[,2])
      contagem <- sum(res < 0.5)
      coef$pacertos[i] <- round(contagem / total, digits = 2) * 100
    }
    return(coef = coef)
}
