options(geoR.messages=F)
##
##  1. Simulando dados do
##     Modelo Geoestatstico Bsico
##     mu = 0, sigma^2 = 1, phi = 2,5
set.seed(123)
## Definindo coordenadas dos pontos
x1 <- c(2, 5, 6, 9, 3)
x2 <- c(1, 4, 3, 2, 8)
## visualizando as localizaes dos pontos 
plot(0:10, 0:10, type="n")
points(x1,x2)
## calculando a matrix de distncia entre pontos
args(dist)
D <- as.matrix(dist(cbind(x1,x2),diag=T,upper=T))
D
## calculando a matrix de covarincia
S <- 1*exp(-D/2.5)
## obtendo a "raiz quadrada" da matriz
Ssq <- chol(S)
## simulando dados
y <- as.vector(round(0 + Ssq %*% rnorm(5), dig=2))
y
plot(0:10, 0:10, type="n")
points(x1,x2)
text(x1,x2,round(y, dig=2), pos=3)


# 2. Estimando os parmetros do modelo 
#    usando o semivariograma
# calcular distncias
u <- as.vector(dist(cbind(x1,x2)))
u
# calculando 1/2 das diferenas ao quadrado
v <- as.vector((dist(y)^2)/2)
plot(u, v, xlim=c(0, max(u)), ylim=c(0,max(v))) 
useq <- seq(0,9, l=100)
vseq <- 0.1 + 0.8 * (1 - exp(-useq/2.5))
lines(useq, vseq)
vseq1 <- 0.05 + 0.6 * (1 - exp(-useq/2))
lines(useq, vseq1, col=2)

## modelo escolhido vseq1

## krigando (estimando em um ponto)
## construindo a matrix de cov. dos dados
D <- as.matrix(dist(cbind(x1,x2),diag=T,upper=T))
Sest <- 0.05 * diag(5) + 0.6*exp(-D/2)
## estimando mdia
uns <- rep(1,5)
mest <- solve(t(uns) %*% solve(Sest) %*% uns) %*%
  t(uns) %*% solve(Sest) %*% y
mest

## estimando em um ponto da rea
x0 <- c(6,6)
plot(0:10, 0:10, type="n")
points(x1,x2)
text(x1,x2,round(y, dig=2), pos=3)
text(6,6,"?", col=2, cex=2)
## distncia entre o ponto a ser estimado e cada dado
d0 <- as.vector(dist(rbind(x0, cbind(x1,x2))))[1:5]
## covarincias entre o ponto a ser estimado e cada dado
S0 <- 0.6 * exp(-d0/2)
## predizendo no ponto escolhido
Yest <- mest + t(S0) %*% solve(Sest) %*% (y-mest) 
Yest
## e a varincia da estimativa
Yest.var <- (0.05+0.6) - t(S0) %*% Sest %*% S0
Yest.var

plot(0:10, 0:10, type="n")
title("predicao e erros padrao")
points(x1,x2)
text(x1,x2,round(y, dig=2), pos=3)
text(6,6,"?", col=2)
text(6,6,round(Yest, dig=2), col=2, pos=3)
text(6,6,paste("(",round(sqrt(Yest.var), dig=2),")"), col=2,pos=1)

## fazendo predicoes em outros pontos
## vamos concatenar comandos em uma funo
pt.pred <- function(x0){
  d0 <- as.vector(dist(rbind(x0, cbind(x1,x2))))[1:5]
  S0 <- 0.6 * exp(-d0/2)
  Yest <- mest + t(S0) %*% solve(Sest) %*% (y-mest) 
  Yest.var <- (0.05+0.6) - t(S0) %*% Sest %*% S0
  return(c(Yest,Yest.var))
}

pt.pred(c(1,1))
pt.pred(c(x1[3],x2[3]))
y[3]
pt.pred(c(x1[2],x2[2]))
y[2]
  
require(geoR)
data(Ksat)
Kc <- Ksat$coords
plot(Kc, asp=1)
Kd <- log(Ksat$data)

u <- as.vector(dist(Kc))
length(u) 
range(u)
# calculando 1/2 das diferenas ao quadrado
v <- as.vector((dist(Kd)^2)/2)
plot(u, v, xlim=c(0, max(u)), ylim=c(0,max(v))) 

cl <- seq(0,18, by=2)
cl
u.cl <- cut(u, breaks=cl)
table(u.cl)
v.cl <- tapply(v, u.cl, mean)
plot(seq(1,17,by=2), v.cl, xlim=c(0, 18), ylim=c(0, max(v.cl)))

useq <- seq(0,18, l=100)
vseq <- 0.5 + 2 * (1 - exp(-useq/3))
lines(useq, vseq)

useq <- seq(0,18, l=100)
vseq1 <- 0.5 + 2 * (1 - exp(-useq/1))
lines(useq, vseq1, col=2)

useq <- seq(0,18, l=100)
vseq2 <- 0.5 + 2 * (1 - exp(-useq/5))
lines(useq, vseq2, col=4)

useq <- seq(0,18, l=100)
vseq3 <- 0.5 + 2 * (1 - exp(-useq/0.001))
lines(useq, vseq3, col=6)

