options(geoR.messages=F)
##
## Spatial prediction (kriging) using geoR function krige.conv()
## in the presence of cavariate (external trend)

## loading the package
require(geoR)

## loading data set \code{ca20}
data(ca20)

## more on this data with
## help(ca20)

## a quick data summary
summary(ca20)

## names in the data object 
names(ca20)


## visualising data and the division of the study area in sub-areas
points(ca20, borders=borders)
polygon(ca20$reg1)
polygon(ca20$reg2)
polygon(ca20$reg3)

## Consider the following model for the mean of the proccess
## covariates : a linear trend with the Y coordinate
##              + an effect of the sub-areas
##
## model for the correlation function: exponential
##
## an variogram as an exploratory tool
v <- variog(ca20, trend=~area+ca20$coords[,2])
plot(v)

## model parameter estimates using maximum likelihood
ml <- likfit(ca20, trend=~area+ca20$coords[,2], ini=c(100, 400), nug=40)
ml

## Spatial prediction (kriging)

## a rectangular grid over the area
gr0 <- pred_grid(ca20$borders, by=50)

## visialising the prediction grid
points(ca20)
points(gr0, pch="+")

## selecting prediction points within the area
gr <- polygrid(gr0, bor=ca20$borders)
points(gr, pch="+", col=2)

## creating the covariate "gr.area" for the prediction locations
## indicating the sub-area each prediction point belongs to 
gr.area <- numeric(nrow(gr))
gr.area[.geoR_inout(gr, poly=ca20$reg1)] <- 1
gr.area[.geoR_inout(gr, poly=ca20$reg2)] <- 2
gr.area[.geoR_inout(gr, poly=ca20$reg3)] <- 3
gr.area <- as.factor(gr.area)

## checking the covariate
points(ca20, borders=borders)
polygon(ca20$reg1)
polygon(ca20$reg2)
polygon(ca20$reg3)
text(gr[,1], gr[,2], as.character(gr.area))

length(gr.area)
length(gr[,2])
dim(gr)

## setting the kriging options
KC <- krige.control(trend.d=~area+ca20$coords[,2], trend.l=~gr.area+gr[,2], obj=ml)
## performing the spatial prediction
kr <- krige.conv(ca20, loc=gr0, borders=ca20$borders, krige=KC)

## visualising the prediction
image(kr, col=gray(seq(1,0,l=51)))
polygon(ca20$reg1)
polygon(ca20$reg2)
polygon(ca20$reg3)

## an alternative way to run kriging withing the borders of the area
kr <- krige.conv(ca20, loc=gr, krige=KC)
image(kr, col=gray(seq(1,0,l=51)), loc=gr0, bor=ca20$b)

