options(geoR.messages=F)
require(geoR)
##
## Converting krige.conv() output do SpatialGridDataFrame and SpatialPixelDataFrame
## formats defined by the "sp" package
##

## A conversion function will soon be added to the geoR package

##
## Example 1: converting a rectangular prediction grid
## 

data(s100)
ml.s <- likfit(s100, ini=c(1, .20))
gr.s <- expand.grid(seq(0,1,l=15), seq(0,1,len=15))
kc.s <- krige.conv(s100, loc=gr.s, krige=krige.control(obj=ml.s))

## Option 1: converting krige.conv() prediction grid results to SpatialGridDataFrame
## building the grid topology step-by-step
cs <- c(min(abs(diff(unique(gr.s[,1])))), min(abs(diff(unique(gr.s[,2])))))
cs
cco <- unname(apply(gr.s,2,min))
cco
cd <- ceiling(diff(t(bbox(as.matrix(gr.s))))/cs)
GT.s <- GridTopology(cellcentre.offset = cco, cellsize=cs, cells.dim=cd)
GT.s

## or ... a more direct/straightforward way  
GT.s <- points2grid(SpatialPoints(as.matrix(gr.s)))
GT.s

## notice the need to reorder coordinates
reorder <- as.vector(matrix(1:nrow(gr.s), nc=slot(GT.s, "cells.dim")[2])[,slot(GT.s, "cells.dim")[2]:1])
SGDF.s <- SpatialGridDataFrame(grid=GT.s,
                               data=as.data.frame(kc.s[1:2])[reorder,])
rm(reorder)

## comparing image plot of the objects
par(mfrow=c(2,2), mar=c(1.5,1.5,1,0.5), mgp=c(1.8,0,0))
image(kc.s)
image(SGDF.s, axes=T)
image(kc.s, val=kc.s$krige.var)
image(SGDF.s['krige.var'], axes=T)

## Option 2: converting to SpatialPixelDataFrame and then to SpatialGridDataFrame
SPxDF.s <- SpatialPixelsDataFrame(gr.s, data = as.data.frame(kc.s[1:2]))
SGDF.s1 <- as(SPxDF.s, "SpatialGridDataFrame")

## image plots
par(mfrow=c(2,3), mar=c(1.5,1.5,1,0.5), mgp=c(1.8,0,0))
image(kc.s, main="krige.conv")
image(SPxDF.s, axes=T)
image(SGDF.s, axes=T)
image(kc.s, val=kc.s$krige.var, main="krige.conv")
image(SPxDF.s['krige.var'], axes=T)
image(SGDF.s['krige.var'], axes=T)


## Option 3: yet another way by converting the prediction grid to SpatialPixelDataFrame
gr.s$predict <- NA
coordinates(gr.s) <- names(gr.s)[1:2]
gridded(gr.s) <- TRUE
class(gr.s)
gr.s$predict <- kc.s$pred
gr.s$krige.var <- kc.s$krige.var

gr.sSGDF <- as(gr.s, "SpatialGridDataFrame")
class(gr.sSGDF)
image(gr.sSGDF)

##
## Example 2: converting a grid defined in a non-rectangular region
##
data(parana)
ml.pr <- likfit(parana, ini=c(100, 40), trend="1st")
## defining a rectangular grid over the study area
gr.pr <- pred_grid(parana$borders, by=20)
points(parana)
points(gr.pr, pch=19, cex=0.25, col=2)
kc.pr <- krige.conv(parana, loc = gr.pr, krige=krige.control(obj.model=ml.pr,
                                           trend.d="1st", trend.l="1st"))

## Option 1: converting directly to SpatialGridDataFrame
GT.pr <- points2grid(SpatialPoints(as.matrix(gr.pr)))
GT.pr
ind <- .geoR_inout(gr.pr, parana$borders)
reorder <- as.vector(matrix(1:nrow(gr.pr), nc=slot(GT.pr, "cells.dim")[2])[,slot(GT.pr, "cells.dim")[2]:1])

df.pr <- data.frame(predict=rep(NA, nrow(gr.pr)), krige.var=rep(NA, nrow(gr.pr)))
df.pr[ind,] <- as.data.frame(kc.pr[1:2])
SGDF.pr <- SpatialGridDataFrame(grid=GT.pr, data=df.pr[reorder,])

## comparing image plot of the objects
par(mfrow=c(2,2), mar=c(1.5,1.5,1,0.5), mgp=c(1.8,0,0))
image(kc.pr)
image(SGDF.pr, axes=T)
image(kc.pr, val=kc.pr$krige.var)
image(SGDF.pr['krige.var'], axes=T)


##
## Option 2: Converting to SpatialPixelDataFrame and then to SpatialGridDataFrame
##
SPxDF.pr <- SpatialPixelsDataFrame(locations.inside(gr.pr, parana$borders),
                                   data = as.data.frame(kc.pr[1:2]))                          
SGrDF.pr <- as(SPxDF.pr, "SpatialGridDataFrame")

## image plots
par(mfrow=c(2,3), mar=c(1.5,1.5,1,0.5), mgp=c(1.8,0,0))
image(kc.pr)
image(SPxDF.pr, axes=TRUE)
image(SGrDF.pr, axes=TRUE)
image(kc.pr, val=kc.pr$krige.var)
image(SPxDF.pr["krige.var"], axes=TRUE)
image(SGrDF.pr["krige.var"], axes=TRUE)

## Option 3: yet another way by converting the prediction grid to SpatialPixelDataFrame
gr.pr$predict <- NA
coordinates(gr.pr) <- names(gr.pr)[1:2]
gridded(gr.pr) <- TRUE
class(gr.pr)
gr.pr$predict[ind] <- kc.pr$pred
gr.pr$krige.var[ind] <- kc.pr$krige.var

image(gr.pr)

gr.prSGDF <- as(gr.pr, "SpatialGridDataFrame")
class(gr.prSGDF)
image(gr.prSGDF)
