options(geoR.messages=F)
#####################################
##
## Simulando dados com a funo grf()
## (simulao nao-condicional)
##
#####################################
##
## 1. Preparativos iniciais
## ------------------------
##
##
## 1.1 Carregando o pacote geoR
##
require(geoR)
##
## 1.2 Iniciando a ajuda no formato html (opcional)
##
## options(htmlhelp=TRUE)
## help.start()
##
## 1.3 Salvando padres grficos iniciais e inicializando o gerador de numeros aleatorios 
##
par.ori <- par(no.readonly = TRUE)
if(!exists(".Random.seed")) set.seed(123)
##
## 1.4 Inspecionando os argumentos da funo grf()
##
args(grf)
#help(grf)
##
## 2. Uma primeira simulao com argumentos minimos usando diversas opes "default"
## ---------------------------------------------------------------------------------
##
## 2.1 simula dados:
##
sim01 <- grf(50, cov.pars=c(1, .25))
##
## 2.2 inspeciona objeto com dados simulados:
##
sim01
##
## 2.3 inspeciona variogramas terico e emprico
##
plot(sim01)
##
## 2.4 visualizando as localizaoes simuladas
##
## pode-se ainda visualizar as localizaes dos dados simulados

#plot(sim01, plot.loc=T)
## ou usar funes padrao de visualizao de dados
plot.geodata(sim01)
points.geodata(sim01)
##
## Nota: veja ainda opes destas funes com:
##        args(plot.geodata)
##        args(points.geodata)
##
##
## 3. Uma segunda simulao em grid regular
## ----------------------------------------
##
## 3.1 Simulando dados
##
sim02 <- grf(256, cov.pars=c(1, .3), grid="reg") 
##
## 3.2 Visualizando as simulaes em grid regular
##
points.geodata(sim02)
image(sim02)
persp(sim02)
## e, se desejar mude o angulo de visualizao 
persp(sim02, theta=30, phi=20)
##
## Exercicio 01: Explorando as opes graficas
##
##  - inspecione outras opes em help(image.grf) e help(persp.grf)
##    e use estas opes para midoficar os graficos
##
##  - use as outras funes de visualizao mencionadas anteriormente
##    (plot, plot.geodata, points.geodata)
##
##
## Exercicio 02: Explorando outros argumentos da funo grf()
##
##  - gere novas simulaes usando os argumentos: nx, ny, xlims e ylims
##
##
## 4. Usando simulaes em 1D para compreender o modelo e seus parametros
## ----------------------------------------------------------------
##
## 4.1 Simulando com diferentes alcances ("range") definidos pelo parametro $\phi$ 
##
sim11 <- grf(100, ylims=c(0,0), cov.pars=c(1, 0.25))
image(sim11)
image(sim11, type="l")
image(sim11, type="b", cex=0.5)
##
sim12 <- grf(100, ylims=c(0,0), cov.pars=c(1, 0.0))
image(sim12, type="l")
##
sim13 <- grf(100, ylims=c(0,0), cov.pars=c(1, 0.5))
image(sim13, type="l")
##
par(mfrow=c(3,1), mar=c(2,2,1,1))
yl <- range(c(sim11$data, sim12$data, sim13$data))
image(sim11, type="l", ylim=yl)
image(sim12, type="l", ylim=yl)
image(sim13, type="l", ylim=yl)
par(par.ori)
##
## Exercicio 03: 
##
##  - gere diferentes simulaes variando o parametro $\sigma^2$ no argumento cov.pars
##    e discuta os resultados
##
##
## 4.2 Simulaes com diferentes modelos de variograma
##
sim21 <- grf(100, ylims=c(0,0), cov.pars=c(1, 0.75), cov.model="sph")
image(sim21, type="l")
##
sim22 <- grf(50, ylims=c(0,0), cov.pars=c(1, 0.75/sqrt(3)), cov.model="mat", kappa=2)
image(sim22, type="l")
##
par(mfrow=c(3,1), mar=c(2,2,1,1))
yl <- range(c(sim11$data, sim21$data, sim22$data))
image(sim11, type="l", ylim=yl)
image(sim21, type="l", ylim=yl)
image(sim22, type="l", ylim=yl)
par(par.ori)
##
##
## Exercicio 04: Explorando os modelos de variograma
##
##  - gere e compare simulaes com o modelo de Matern
##    (cov.model="mat") com diferentes valores
##    no argumento kappa (tente, por exemplo valores 0.5, 2 e 5)
##
##  - tente tambem com cov.model="gau" e observe se ha'
##    mensagens de alerta
##
##  - gere e compare simulaes com outros modelos de variogramas
##
##
## 4.3 Simulaes com ruido
##
sim31 <- grf(50, ylims=c(0,0), cov.pars=c(1, 0.75/sqrt(3)), nugget = 0.1, cov.model="gau")
##
## repare novamente se ha' alguma mensagem de alerta (warning) !
##
image(sim31, type="l")
##
## Agora gerando simulaes com a mesma "semente" e com
## diferentes  nveis de rudo
##
set.seed(12)
sim32 <- grf(100, ylims=c(0,0), cov.pars=c(1, 0.25))
##
set.seed(12)
sim33 <- grf(100, ylims=c(0,0), cov.pars=c(1, 0.25), nug=0.25)
##
set.seed(12)
sim34 <- grf(100, ylims=c(0,0), cov.pars=c(1, 0.25), nug=0.5)
##
par(mfrow=c(3,1), mar=c(2,2,1,1))
yl <- range(c(sim32$data, sim33$data, sim34$data))
image(sim32, type="l", ylim=yl)
image(sim33, type="l", ylim=yl)
image(sim34, type="l", ylim=yl)
par(par.ori)
##
##
## Exercicio 05: Simulaes com ruido
##
##  - gere em compare mais simulaes com differentes valores no argumento nugget
##
##
## 5. Modelos com anisotropia
## --------------------------
##
## simulao sem estrutura espacial
sim39 <- grf(961, grid="reg", cov.pars=c(1, 0))
image(sim39)
## simulao com estrutura espacial isotropica
sim40 <- grf(961, grid="reg", cov.pars=c(1, .15))
image(sim40)
## simulao com estrutura espacial anisotropica
sim41 <- grf(961, grid="reg", cov.pars=c(1, .15), aniso.pars=c(pi/4, 3))
image(sim41)
##
## Exercicio 06: Simulaes com anisotropia
##
##  - gere em compare simulaes com differentes valores no argumento aniso.pars
##
##
## 6. Simulando modelos com tendencia
## ----------------------------------
##  A funo grf gera simulaes com media constante e igual a zero.
##  Para gerar simulaes com media diferente de zero basta somar
##  quantidades desejadas aos dados simulados como no exemplo a seguir
##
sim51 <- grf(100, ylims=c(0,0), cov.pars=c(1, 0.25))
sim51$data <- 10 - 5*sim51$coords[,1] + sim51$data
image(sim51, ty="l")
##
##
## 7. Simulaes de variaveis nao-Gaussianas
##
## Simulao de variavel log-Normal
##
sim61 <- grf(961, grid="reg", cov.pars=c(1, 0.25), lambda = 0)
image(sim61)
hist(sim61$data)
##
## Simulao de variavel Poisson
##
sim71 <- grf(121, grid="reg", cov.pars=c(1, 0.25))
sim71$data <- rpois(121, exp(0.5 + sim71$data))
image(sim71, col=gray(seq(1,0.2,l=11)))
text(sim71$coords[,1], sim71$coords[,2], sim71$data)
barplot(table(sim71$data))
##
## Exercicio 07: Simulaes de variaveis nao-Gaussianas
##
##  - gere, explore e compare simulaes com differentes valores no argumento lambda
##  - gere simulaes com variavel resposta Binomial
##
##
## 8. Gerando simulaes em grids muito finos (malha com muitos pontos)
##
## Use o pacote RandomFields
##
## =======================================================
## Para mais sobre simulaes veja o pacote RandomFields.
## =======================================================
##


