options(geoR.messages=F)
##
## Simulando do Modelo Linear Generalizado
##
## Exemplo 1: Modelo Binomial (Bernoulli)
##            com ligao "logit"
## valores da covarivel:
x <- c(23, 28, 25, 27, 32, 45, 51)
n <- length(x)
## Definindo o valor do parmetro $\beta$
beta <- .03

## calculando o vetor de mdias $\mu$
mu <- exp(x * beta)/(1+ exp(x*beta))
mu
## Simulando dados
y <- rbinom(n, size=1, prob=mu)
y

## Exemplo 2: Modelo Poisson
##            com ligao "log"
##            (usando a mesma covarivel)
beta <- 0.05

## calculando o vetor de mdias $\mu$
mu <- exp(x * beta)
mu

## Simulando dados
y <- rpois(n, lam=mu)
y

## Exemplo 3: Modelo Poisson com efeito aleatrio
##            com ligao "log"
beta <- 0.05
x * beta

## simulando o efeito aleatrio
u <- rnorm(n, sd=1)
u
## termo $X\beta + U$
x * beta + u

## calculando o vetor de mdias $\mu$
mu <- exp(x * beta + u)

## Simulando dados com efeito aleatrio
set.seed(123)
y <- rpois(n, lam=mu)
y

## Mesma simulao sem o efeito aleatrio
set.seed(123)
y <- rpois(n, lam=exp(x*beta))
y

## Exemplo 4: Simulando do modelo Poisson
##            com efeito espacial
##            com funo de ligao "log"

## definindo as coordenadas dos pontos
cp <- expand.grid(1:10, 1:10)
cp
plot(cp, asp=1)

## simulando valores nestes pontos
require(geoR)
s <- grf(grid=cp, cov.pars=c(2, 3))$data

## calculando a mdia
mu <- exp(s)

## simulando da Poisson
y <- rpois(100, lam=mu)
plot(cp, asp=1, type="n")
text(cp[,1], cp[,2], y, cex=2)

## visualizando S e Y
par(mfrow=c(1,2), mar=c(3,3,0.5,0.5), mgp=c(2,1,0))
plot(cp, asp=1, type="n")
text(cp[,1], cp[,2], round(s, dig=2), cex=1.5)
plot(cp, asp=1, type="n")
text(cp[,1], cp[,2], y, cex=1.5)

##
## Mais exemplos sobre simulao de modelos Poisson e Binomial
##
##
## I. Simulando do modelo Poisson - log link
##
## $$Y(x) \sim P(\lambda(x))$$

## 1.
## simulando com intensidade proporcional  S(x)
## $$\lambda(x) = \exp(S(x)) $$ 
set.seed(23)
S <- grf(100, cov.pars=c(1, 0.25))

S1 <- S
S1$data <- exp(S$data)
set.seed(351)
y1 <- rpois(100, lam=S1$data)

points(S1)
text(S1$coords, lab=y1, col=4,pos=4, offset=0.3)

## 2. adicionando uma mdia contante
## $$\lambda(x) = \exp(\mu + S(x)) $$ 
S2 <- S
S2$data <- exp(1 + S$data)
set.seed(351)
y2 <- rpois(100, lam=S2$data)

points(S2)
text(S2$coords, lab=y2, col=4,pos=4, offset=0.3)

## 3. adicionando um rudo ao processo S
## $$\lambda(x) = \exp(\mu + S(x) + \epsilon) $$ 
S3 <- S
err <- rnorm(100, sd=0.1)
S3$data <- exp(1 + S$data + err)
set.seed(351)
y3 <- rpois(100, lam=S3$data)

points(S3)
text(S3$coords, lab=y3, col=4,pos=4, offset=0.3)

## comparando os valores e termos
round(cbind(S=S$data, lam1=S1$data, y1, lam2=S2$data, y2, lam3=S3$data, err, y3), dig=3)

##
## II. Simulando do modelo Binomial(n=1) - logit link
##
## $$Y(x) \sim P(\lambda(x))$$

## 1.
## simulando com intensidade proporcional  S(x)
## $$\lambda(x) = \frac{\exp(\mu+S(x))}{1+\exp(S(x))} $$ 
S4 <- S
S4$data <- exp(S$data)/(1+exp(S$data))
set.seed(351)
y4 <- rbinom(100, size=1, prob=S4$data)
y4
sum(y4)
points(S4)
text(S4$coords, lab=y1, col=4,pos=4, offset=0.3)

## 2. simulando com intensidade proporcional  S(x) + uma mdia cte
## $$\lambda(x) = \frac{\exp(\mu+S(x))}{1+\exp(\mu+S(x))} $$ 
S5 <- S
S5$data <- exp(2+S$data)/(1+exp(2+S$data))
set.seed(351)
y5 <- rbinom(100, size=1, prob=S5$data)
y5
sum(y5)
points(S5)
text(S5$coords, lab=y1, col=4,pos=4, offset=0.3)
