options(geoR.messages=F)
##
## Anlises exploratrias iniciais e espaciais
##

## A anlise exploratria espacial tenta identificar:
## 1. presena de dependncia espacial
## 2. a existncia de dados discrepantes (globais ou locais)
## 3. assimetrias, necessidades de transformao, etc
## 4. tendncias com coordenadas ou covariveis

## carregando o pacote geoR
require(geoR)

## carregando o conjunto de  dados "s100" (distribudo com a geoR)
data(s100)

## um resumo dos dados
summary(s100)

## inspecionando o objeto
names(s100)

## ilustrantd algumas operaes bsicas que podem ser feitas com os dados
var(s100$data)
boxplot(s100$data)

##
## Anlise exploratria espacial
##

##
## Usando a funo points.geodata(), e ilustrando algumas de suas opes
##
points(s100)
## controlando o tamanho dos pontos
points(s100, pt.div="equal")
points(s100, cex.min=.6, cex.max=.6)
points(s100, cex.min=.3, cex.max=3)
## dividindo os dados em quantis 
points(s100, cex.min=1, cex.max=1, pt.div="quart")
points(s100, pt.div="quart")
points(s100, pt.div=4)
points(s100, pt.div="dec")
points(s100, cex.min=1, cex.max=1, pt.div="quint")
## opes para cores dos pontos
points(s100, cex.min=1, cex.max=1, col="gray")
points(s100, cex.min=1, cex.max=1, col=rainbow(100))
points(s100, cex.min=1, cex.max=1, col=terrain.colors(100))
## opo para modificar caracter dos pontos
points(s100, pt.div="equal", pch.seq="+")

## Verificando o aspecto do grficos para  dados sem correlao espacial
## (permutando a localizao dos dados para gerar dados espacialmente independentes)
points(s100, data=sample(s100$data))
## e agora compare com o padro dos dados originais
X11(); points(s100)
dev.off()

## verificando o aspecto de dados assimtricos
## (exponenciando dados para gerar dados log-normais)
points(s100, data=exp(s100$data))

## inspecionando argumentos e outras opes da funo
class(s100)
args(points.geodata)
help(points.geodata)

## Carregando um outro conjunto de dados
data(parana)
summary(parana)

## Note a tendncia nestes dados:
points(parana, border=borders)
## agora "removendo" a tendncia, isto , fazendo o grfico dos resduos
## de uma regresso linear nas coordenadas
points(parana, border=borders, trend="1st")
points(parana, border=borders, trend="1st", pt.div="quart")
## permutando os dados nas posies para ver aspecto do grfico
## sem correlao espacial
X11();points(parana, data=sample(parana$data),border=borders, trend="1st", pt.div="quart")
dev.off()

##
## Um outro grfico descritivo: usando a funo plot.geodata()
##
plot(s100)
plot(parana)
## alguns argumentos adicionais
plot(parana, bor=borders, low=T)
## agora compare anterior com os grfico dos resduos ("retirando a tendncia")
X11(); plot(parana, trend="1st", bor=borders, low=T)
dev.off()

## Carregando um outro conjunto de dados que possui covariveis
data(ca20)
summary(ca20)
names(ca20)
points(ca20, cex.min=0.5, cex.max=0.5, bor=borders)
polygon(ca20$reg1)
polygon(ca20$reg2)
polygon(ca20$reg3)

plot(ca20, bor=borders)
plot(ca20, bor=borders, trend=~area)
plot(ca20, bor=borders, trend=~area+altitude)

## Carregando um outro conjunto de dados com comortamento assimtrico
ksat <- read.geodata("http://www.leg.ufpr.br/geoR/tutorials/datasets/Cruciani.dat", head=T, row.names=1) 
summary(ksat)
plot(ksat)

require(MASS)
boxcox(ksat)
## o grfico produzido mostra que a transformao recomendada  lambda=0 (log)

## visualizando dados transformados
plot(ksat, lambda=0)

## Melhorando o grfico
## carregando as bordas
kbor <- read.table("http://www.leg.ufpr.br/geoR/tutorials/datasets/Cruciani.border", head=T, row.names=1) 
kbor
plot(ksat, lambda=0, bor=kbor)
points(ksat, lambda=0, bor=kbor)

##
## Explorando a dependncia espacial atravs dos variogramas:
## variograma exploratrio (emprico)
##
s100.v <- variog(s100, max.d=1)
plot(s100.v)

## dados com tendncia: obtendo variograma dos resduos 
parana.v <- variog(parana, max.dist=400, trend="1st")
plot(parana.v)

## dados com tendncia em covariveis: variograma dos resduos
ca20.v <- variog(ca20, trend=~area, max.d=800)
plot(ca20.v)

## variograma para dados transformados
ksat.v <- variog(ksat, max.d=10, lam=0)
plot(ksat.v)

