options(geoR.messages=F)
## Lendo os dados no R
ctc <- read.table("http://www.leg.ufpr.br/geoR/tutorials/datasets/ctc.dat", head=T)
## Visualizando os 5 primeiros dados
ctc[1:5,]

require(geoR)
## colocando os dados no formato geodata da geoR
ctc <- as.geodata(ctc)

## Visualizando os dados
points(ctc)
## mudando algumas opcoes de visualizacao
args(points.geodata)
points(ctc, pt.div= "equal")
points(ctc, pt.div= "equal", cex.max=1.2)
points(ctc, pt.div= "quint", cex.max=1, cex.min=1)

## adicionando as bordas
bor <- read.table("http://www.leg.ufpr.br/geoR/tutorials/datasets/ctcborda.dat", head=T)
bor
polygon(bor)
##
points(ctc, pt.div= "quint", cex.max=1, cex.min=1, bord=bor)

## um outro grafico para visualizar os dados
plot(ctc)
#args(plot.geodata)
#help(plot.geodata)
## adicionando uma opcao para ajudar visualizar tendencia
plot(ctc, low=T)

## resumo dos dados
summary(ctc)

## box-plot 
boxplot(ctc$data)

## verificando a necessidade de transformacao de dados
require(MASS)
boxcox(ctc)
## dando ukm zoom na regiao de interesse
boxcox(ctc, lambda=seq(-1,1,l=20))
## indicou a transformacao logaritmica

## refazendo graficos
points(ctc, pt.div= "quint", cex.max=1, cex.min=1, bord=bor, lam=0)
plot(ctc, low=T, lam=0)
par(mfrow=c(2,2))
hist(ctc$data)
hist(log(ctc$data))
boxplot(ctc$data)
boxplot(log(ctc$data))
par(mfrow=c(1,1))

## Descrevendo a dependncia espacial
ctc.v <- variog(ctc, max.dist=20, lam=0)
plot(ctc.v)

## outras opcoes
ctc.v <- variog(ctc, uvec=seq(0,25,l=11), lam=0)
plot(ctc.v)

## ajustando uma curva ao variograma
## no olhometro
#ctc.va <- eyefit(ctc.v)

## por minimos quadrados
ctc.vf <- variofit(ctc.v, ini=c(0.2, 10), cov.model= "exp")
lines(ctc.vf)

ctc.vf

## interpolando
apply(bor,2,range)

gr <- expand.grid(x=seq(-3.6, 38.5, by=.25), y=seq(0,23.6, by=.25)) 
points(ctc, pt.div= "quint", cex.max=1, cex.min=1, bord=bor, lam=0)
points(gr, pch="+")

gi <- polygrid(gr, bor=bor)
points(gi, pch="+", col=2)

KC <- krige.control(obj.mo=ctc.vf, lam=0)
ctc.k <- krige.conv(ctc, loc=gi, krige=KC)

image(ctc.k, loc=gr, border=bor, col=gray(seq(1,0,l=11)))
image(ctc.k, loc=gr, border=bor, col=gray(seq(1,0,l=21)), x.leg=c(0,30), y.leg=c(-8,-4))
