options(geoR.messages=F)
#rm(list=ls())
require(geoR)
options(digits = 3, width = 80)

x <- 1:100
models <- c("exponential", "matern", "gaussian",
            "spherical", "circular", "cubic", "wave", "power",
            "powered.exponential", "cauchy", "gneiting",
            "pure.nugget", "gneiting.matern", "gencauchy")
res <- data.frame(model= models,
                  geoR = factor("notOK", levels=c("OK", "notOK")),
                  covRF = factor("notOK", levels=c("OK", "notOK")),
                  CRF = factor("notOK", levels=c("OK", "notOK")))
                  
for(cm in levels(res$model))
{
  cat(cm)
  kp <- 1.9
  vphi <- 30
  if(cm == "power") vphi <- 1.5
  if(any(cm == c("gneiting.matern", "gencauchy"))) kp <- c(kp, 1.2)
  x1 <- .Ccor.spatial(x, vphi, kp, cm)
  x2 <- cov.spatial(x, cov.model=cm, cov.pars=c(1, vphi), kappa = kp)
  if(isTRUE(all.equal(x1,x2))){
    cat("..........OK\n")
    res$geoR[res$model == cm] <- "OK"
  }
  else
    cat("........not OK\n")
  geoRRF <- geoR2RF(cm, cov.pars=c(1,vphi), kappa=kp)
  if(require(RandomFields) && all(geoRRF != "not compatible")){
    p <- c(NA,1,0,vphi)
    if(any(cm == c("matern", "powered.exponential", "cauchy", "gencauchy")))
      p <- c(p,kp)
    x3 <- CovarianceFct(x, geoRRF$model, geoRRF$param)
    if(isTRUE(all.equal(x1,x3)))
      res$covRF[res$model == cm] <- "OK"
    if(all(abs(x1-x3) < 1e-12))
      res$CRF[res$model == cm] <- "OK"
  } 
}

print(res)

