options(geoR.messages=F)
##
## Ilustrando os clculos dos passos bsicos de uma anlise geoestatstica
##

## 1) Lendo os dados
##    --------------
##xy <- read.table("http://www.leg.ufpr.br/geoR/tutorials/datasets/xy.dat")
xy <- read.table("xy.dat")
xy
x <- xy[,1:2]
x
y <- xy[,3]
y
n <- length(y)
n

## visualizando
plot(x, asp=1)
text(x, lab=as.character(y), pos=3)
     
## especificando ponto a ser predito
x0 <- c(4,4)
x0

points(t(x0), pch="?", col=2, cex=2)

## 2) Clculos da estimao do variograma
##    -----------------------------------
## Calculando matrix de distncias (euclidianas) entre dados
u <- dist(x)
u

## Calculando a semivarincia para cada par de pontos
dist(y)
v <-  as.vector(0.5 * (dist(y)^2))
v

## grfico da nuvem variogrfica
## (note que o grfico deve incluir a origem) 
plot(u, v, xlim=c(0, max(u)), ylim=c(0, max(v)))

## calculando variograma em classes de distncia
## limites das classes de distncia: (0, 2, 4, 6, 8)
## pontos mdios : (1, 3, 5, 7)
abline(v=c(0,2,4,6,8), lty=2)
ind <- cut(u, br=c(0,2,4,6,8))
ind
vm <- tapply(v, ind, mean)
um <- c(1,3,5,7)

points(um, vm, pch="x", col=4, cex=2)

plot(um, vm, xlim=c(0, max(um)), ylim=c(0, max(vm, na.rm=T)))

## ajustando o modelo gaussiano ("a olho")
plot(function(x) 0.5 + 5 * (1 - exp(-(x/3)^2)), 0, 7, add=T)

## considerando que as estimativas dos parmetros so:
tau2 = 0.5
sigma2 = 5
phi = 3

## 3) Estimando a mdia geral
##    -----------------------
## Calculando a matrix R de correlao entre dados
R <- exp(-(u/phi)^2)
R
R <- as.matrix(R)
R
diag(R) <- 1
R
## Matrix de varincias e covarincias
Sigma <- tau2 * diag(5) + sigma2 * R

## Estimando a mdia
um <- rep(1,5)
mu <- solve(t(um) %*% solve(Sigma) %*% um) %*% (t(um) %*% solve(Sigma) %*% y) 
mu

## 4) Predio em um certo ponto (krigagem)
##    ------------------------------------
## Estimando ponto no posio (4,4)
## Calculando distncias entre cada dado e o ponto a ser predito
u0 <- dist(rbind(x0,x))[1:n]
u0
## Calculando a matrix r de correlao entre dados e ponto a ser predito
r <- exp(-(u0/phi)^2)
r
## Encontrando o valor da estimativa
y0 <- mu +
  (sigma2*t(r))%*%solve(tau2*diag(n)+sigma2*R)%*%(y - mu) 
y0

## e a varincia da estimativa
v.y0 <- sigma2 -
   (sigma2*t(r)) %*% solve(tau2*diag(n)+sigma2*R) %*% (sigma2*r) 
v.y0

## estimando probabilidades
## i. P(Yest > 10)
pnorm(10, m=y0, sd=sqrt(v.y0), low=F)
## ii  P(Yest < 11)
pnorm(11, m=y0, sd=sqrt(v.y0))

## estimar quantis
## i. a=?  tal que P(Yest < a) = 0.1
qnorm(0.1, m=y0, sd=sqrt(v.y0))
## i. a=?  tal que P(Yest > a) = 0.1
qnorm(0.9, m=y0, sd=sqrt(v.y0))
