options(geoR.messages=F)
require(geoR)
data(ca20)
summary(ca20)
plot(ca20)
plot(ca20, bor=borders)
points(ca20, bor=borders)
polygon(ca20$reg1)
polygon(ca20$reg2)

points(ca20, bor=borders, pt.div="quint")
polygon(ca20$reg1)
polygon(ca20$reg2)

args(points.geodata)

par(mar=c(3,3,0,0), mfrow=c(1,2))
points(ca20, bor=borders, pt.div="quint")
points(ca20, bor=borders, pt.div="quint", perm=T)

## tamanhos dos pontos proporcionais s cotas
par(mar=c(3,3,0,0), mfrow=c(1,1))
points(ca20, bor=borders, cex.var=ca20$covar$altitude,
       pt.div="quint")

par(mar=c(3,3,0,0), mfrow=c(1,2))
with(ca20, plot(data ~ covariate$area))
with(ca20, plot(data ~ covariate$altitude))

## resduos
points(ca20, bor=borders, trend=~area, pt.div="quint", cex.min=1.5)
points(ca20, bor=borders, trend=~area+altitude, pt.div="quint", cex.min=1.5)

## variogramas
par(mar=c(3,3,0,0), mfrow=c(2,2))
v1 <- variog(ca20, max.dist=600)
plot(v1)

v2 <- variog(ca20, max.dist=600, trend=~area, uvec=seq(50,500, by=50))
plot(v2)

v3 <- variog(ca20, max.dist=600, trend=~area+altitude)
plot(v3)

v2.env <- variog.mc.env(ca20, obj=v2)
plot(v2, env=v2.env)

# estimacao via ML

ml1 <- likfit(ca20, ini=c(100, 80))
ml2 <- likfit(ca20, ini=c(100, 80), trend=~area)
ml3 <- likfit(ca20, ini=c(100, 80) , trend=~area+altitude)
save.image()
ml1
ml2
ml3

## experimentando com mltiplos valores iniciais e valores de kappa
inis <- expand.grid(seq(50,200, by=25), seq(50,100, by=10))
ml0.2 <- likfit(ca20, ini=inis, trend=~area, kappa=0.2)
ml0.5 <- likfit(ca20, ini=inis, trend=~area)
ml1.5 <- likfit(ca20, ini=inis, trend=~area, kappa=1.5)
ml2.5 <- likfit(ca20, ini=inis, trend=~area, kappa=2.5)
ml3.5 <- likfit(ca20, ini=inis, trend=~area, kappa=3.5)
c(ml0.2$loglik, ml0.5$loglik, ml1.5$loglik, ml2.5$loglik, ml3.5$loglik)

fit <- ml0.5
save.image()
#rm(list=ls(pattern="ml"))

## interpolao

## Definindo grid cobrindo a rea
gr <- pred_grid(ca20$borders, by=10)
nrow(gr)

par(mfrow=c(1,1))
points(ca20, bor=borders)
points(gr, pch="+")

## selecionando pontos do grid dentro da rea
gr0 <- polygrid(gr, borders=ca20$bor)
nrow(gr0)
points(gr0, pch="+", col=2)

## visualizando pontos no grid  em cada sub-regio
gr1 <- polygrid(gr, borders=ca20$reg1)
dim(gr1)
points(gr1, pch="+", col=4)
gr2 <- polygrid(gr, borders=ca20$reg2)
dim(gr2)
points(gr2, pch="+", col=8)

## construindo a covarivel indicando a (sub)rea  qual pertence 
## cada ponto a ser predito 
ind.reg <- numeric(nrow(gr0))
length(ind.reg)
#ind.reg[inout(gr0, ca20$reg1, bound=T)] <- 1
#ind.reg[inout(gr0, ca20$reg2, bound=T)] <- 2
#ind.reg[inout(gr0, ca20$reg3, bound=T)] <- 3
ind.reg[.geoR_inout(gr0, ca20$reg1)] <- 1
ind.reg[.geoR_inout(gr0, ca20$reg2)] <- 2
ind.reg[.geoR_inout(gr0, ca20$reg3)] <- 3
ind.reg <- as.factor(ind.reg)
table(ind.reg)

KC <- krige.control(trend.d = ~ca20$covar$area, trend.l = ~ ind.reg,
                    obj.model=fit)
pred <- krige.conv(ca20, loc=gr0, krige=KC)
save.image()
image(pred, loc=gr, bor=ca20$borders, col=gray(seq(1,0, l=21)),
      x.leg=c(4950, 5400), y.leg=c(4800,4850))
polygon(ca20$reg1, bor=4)
polygon(ca20$reg2, bor=4)
polygon(ca20$reg3, bor=4)
image(pred, loc=gr, bor=ca20$borders, col=gray(seq(1,0, l=21)),
      x.leg=c(4950, 5400), y.leg=c(4800,4850), val=sqrt(pred$kr))
polygon(ca20$reg1, bor=4)
polygon(ca20$reg2, bor=4)
polygon(ca20$reg3, bor=4)

