options(geoR.messages=F)
## Loading geoR
require(geoR)

## loading the s100 data-set
data(s100)

## visualising data points
points(s100)

v <- variog(s100)
plot(v)

summary(s100)
#args(plot.variogram)
args(getS3method("plot", "variogram"))
plot(v, pts=c(0.7, 2.1))
names(v)
v$n

v <- variog(s100, max.d=1)
plot(v)
v$n

v$bins.lim

v <- variog(s100, uvec=seq(0, 1, by=0.1))
plot(v)

args(variog)

v <- variog(s100, op="cloud")
plot(v)

#cru <- read.geodata("http://www.leg.ufpr.br/geoR/tutorials/datasets/Cruciani.dat", head=T, coords.col=2:3, data.col=4)
cru <- read.geodata("Cruciani.dat", head=T, coords.col=2:3, data.col=4)
plot(cru)

cru.v <- variog(cru, max.d=9, lam=0)
plot(cru.v)

data(parana)
pr.v <- variog(parana, max.d=450, trend="1st")
plot(pr.v)

data(ca20)
summary(ca20)
ca20.v <- variog(ca20, max.d=700, trend=~area)
plot(ca20.v)

#ca20.ef <- eyefit(ca20.v)
#summary(ca20.ef)

ca20.vf <- variofit(ca20.v, ini=c(60, 100), nug=40)
ca20.vf
plot(ca20.v)
lines(ca20.vf)

plot(ca20.v, pts=c(0,7, 2.1))

args(variog)

plot(ca20.v, ylim=c(0, 180))

ca20.v0 <- variog(ca20, max.d=700, dir=0)
lines(ca20.v0, col=2)

ca20.v45 <- variog(ca20, max.d=700, dir=pi/4)
lines(ca20.v45, col=3)

ca20.v90 <- variog(ca20, max.d=700, dir=pi/2)
lines(ca20.v90, col=4)

ca20.v135 <- variog(ca20, max.d=700, dir=3*pi/4)
lines(ca20.v135, col=5)

ca20.v.env <- variog.model.env(ca20, obj=ca20.v, model=ca20.vf)
lines(ca20.vf, lwd=2)
lines(ca20.v.env)

ca20.v.mc <- variog.mc.env(ca20, obj=ca20.v)
plot(ca20.v)
lines(ca20.v.mc)

ca20.v4 <- variog4(ca20, max.d=700)
plot(ca20.v4)
plot(ca20.v4, omni=T)


ml <- likfit(s100, ini=c(1, .2))
ml

args(krige.conv)
loc1 <- c(0.5, 0.5)
points(t(loc1), pch="?", cex=1.5, col=2)

kr1 <- krige.conv(s100, locations=loc1, krige=krige.control(obj.m=ml))

loc2 <- expand.grid(seq(0,1,l=31), seq(0,1, l=31))
points(loc2, pch="+", col=3)

kr2 <- krige.conv(s100, locations=loc2, krige=krige.control(obj.m=ml))
names(kr2)
kr2$pred

image(kr2)
points(s100, add=T)
image(kr2, col=gray(seq(1,0, l=31)))
image(kr2, col=gray(seq(1,0, l=4)))
image(kr2, col=terrain.colors(30))

image(kr2, val=sqrt(kr2$krige.var))
image(kr2, val=sqrt(kr2$krige.var), coords.d=s100$coords)

args(krige.conv)
args(output.control)

OC <- output.control(thres=2)
kr2 <- krige.conv(s100, locations=loc2, krige=krige.control(obj.m=ml), out=OC)
names(kr2)
image(kr2, val=1-kr2$prob, col=gray(seq(1,0, l=21)))

OC <- output.control(thres=2, quant=c(0.1, 0.5, 0.9))
kr2 <- krige.conv(s100, locations=loc2, krige=krige.control(obj.m=ml), out=OC)
names(kr2)
dim(kr2$quant)
image(kr2, val=1-kr2$quan[,1], col=gray(seq(1,0, l=21)))

image(kr2, val=1-kr2$quan[,3], col=gray(seq(1,0, l=21)), x.l=c(0, .4), y.leg=c(-.1, 0))
image(kr2, val=1-kr2$quan[,3], col=gray(seq(1,0, l=5)), x.l=c(0, .4), y.leg=c(-.1, 0))

##

args(xvalid)

ml1 <- likfit(s100, ini=c(1, .2), cov.model="sph")
ml.xv <- xvalid(s100, model=ml, reest=T)
ml.xv1 <- xvalid(s100, model=ml1)

par(mfcol=c(5,2), mar=c(2.5, 2.5, 0,0), mgp=c(1.7,.7,0))
plot(ml.xv)

#X11()
par(mfcol=c(5,2), mar=c(2.5, 2.5, 0,0), mgp=c(1.7,.7,0))
plot(ml.xv1)

args(krige.bayes)

args(model.control)
MC <- model.control()
args(prior.control)
PC <- prior.control(phi.disc=seq(0, 2, l=21), tausq.rel.disc=seq(0,2, l=21), tausq.rel.prior="unif")

s100.post <- krige.bayes(s100, prior=PC, model=MC)

names(s100.post)
names(s100.post$post)

s100.post$post$beta
s100.post$post$sigma
s100.post$post$phi
s100.post$post$tausq.rel

par(mfrow=c(2,1), mar=c(3.5,3.5, .5, .5))
plot(s100.post)

x0 <- c(0.5, 0.5)

s100.pred <- krige.bayes(s100, prior=PC, model=MC, loc=x0)
names(s100.pred)

names(s100.pred$pred)
s100.pred$pred

ml <- likfit(s100, ini=c(1, .3))
s100.kc <- krige.conv(s100, loc=x0, krige=krige.control(obj=ml))
s100.kc[1:2]

s100.pred$pred[1:2]
s100.pred$pred[5:6]

PC <- prior.control(phi.disc=seq(0, 2, l=21), phi.prior="exp", phi=0.2, tausq.rel.disc=seq(0,2, l=21), tausq.rel.prior="unif")
s100.pred <- krige.bayes(s100, prior=PC, model=MC, loc=x0)

plot(s100.pred)
s100.pred$pred[1:2]

s100.v <- variog(s100, max.dist=1.1)
plot(s100.v)

#lines(s100.pred)
#help(lines.variomodel.krige.bayes)

lines(s100.pred, sum=mean)
lines(s100.pred, sum=median, lty=2)
lines(s100.pred, sum="mode", lty=2, post="parameters")

hist(s100.pred$pred$simul, prob=T)
lines(density(s100.pred$pred$simul))
