options(geoR.messages=F)
require(geoR)
data(Ksat)

summary(Ksat)
plot(Ksat)
plot(Ksat, lam=0)

v <- variog(Ksat, lam=0, option="cloud")
plot(v)

v <- variog(Ksat, lam=0)
plot(v)

v <- variog(Ksat, lam=0, max.dist=12)
plot(v)

v <- variog(Ksat, lam=0, max.dist=12, uvec=c(seq(0,12, by=1)))
plot(v)

{if(interactive()){
 vf <- eyefit(v);
 vf;
 lines(vf)}
}

vfit <- variofit(v)
lines(vfit, col=4)

# estimando via ML
Kml <- likfit(Ksat, ini=c(2.5, 3), lam=0)
Kml
lines(Kml, lwd=2)

## agora com REML
Kreml <- likfit(Ksat, ini=c(2.5, 3), lik.met="REML", lam=0)
Kreml
lines(Kreml, lwd=2, col=2)

# modelo esferico
Kml1 <- likfit(Ksat, ini=c(2.5, 3), cov.model="sph", lam=0)
Kml1
lines(Kml1, col=4)

# modelo Matrn
Kml2 <- likfit(Ksat, ini=c(2.5, 1.5), cov.model="mat", kap=1.5, lam=0)
Kml2
Kml3 <- likfit(Ksat, ini=c(2.5, 1.5), cov.model="mat", kap=2.5, lam=0)
Kml3
Kml4 <- likfit(Ksat, ini=c(2.5, 1.5), cov.model="mat", kap=3.5, lam=0)
Kml4
Kml5 <- likfit(Ksat, ini=c(2.5, 1.5), cov.model="mat", kap=4.5, lam=0)
Kml5


LL.mat <- c(Kml$loglik,Kml2$loglik,Kml3$loglik,Kml4$loglik,Kml5$loglik)
LL.mat
plot(0.5:4.5,LL.mat) 

## estimando kappa (no recomendado)
#Kmlk <- likfit(Ksat, ini=c(2.5, 1.5), cov.model="mat", kap=1.5, fix.kappa=F, lam=0)

Kml
summary(Kml)

## predicao
names(Ksat)
points(Ksat, bor=borders)
summary(Ksat)
xgr <- seq(0, 22.5, by=0.25)
ygr <- seq(0, 13, by=0.25)
gr <- expand.grid(xgr,ygr)
points(gr, pch=".")

Kpred <- krige.conv(Ksat, loc=gr,
                    bor=Ksat$borders,
                    krige=krige.control(obj.model=Kml))
names(Kpred)

## visualizando
image(Kpred)
image(Kpred, col=terrain.colors(15))
image(Kpred, col=gray(seq(1,0, l=21)))
image(Kpred, col=gray(seq(1,0, l=21)),
      x.leg=c(2,20), y.leg=c(-3,-1.3))
text(20, -1, "(mm/h)")

## media e erro padro
par(mfrow=c(1,2))
image(Kpred, col=gray(seq(1,0, l=21)),
      x.leg=c(2,20), y.leg=c(-3,-1.3),
      coords.data=Ksat$coords)
text(20, -1, "(mm/h)")
image(Kpred, val=sqrt(Kpred$krige),
      col=gray(seq(1,0, l=21)),
      coords.data=Ksat$coords,
      x.leg=c(2,20), y.leg=c(-3,-1.3))

args(krige.conv)
args(output.control)

## simulando da distribuicao condicional
OC <- output.control(n.pred=1000)
Kpred <- krige.conv(Ksat, loc=gr,
                    bor=Ksat$borders,
                    krige=krige.control(obj.model=Kml),
                    output=OC)
names(Kpred)
dim(Kpred$simul)
## estimando a % da area com Ksat > 3
K3 <- apply(Kpred$simul, 2, function(x) sum(x >3)/length(x))
hist(K3)
mean(K3)
quantile(K3, prob=c(0.025, 0.975))

# obtendo as prob. em cada ponto da Ksat ser maior do que 3
Kpx3 <- apply(Kpred$simul, 1, function(x) sum(x >3)/length(x))
image(Kpred, val=Kpx3, col=gray(seq(1,0, l=21)),
      x.leg=c(2,20), y.leg=c(-3,-1.3))

args(statistics.predictive)
## mapas de quartis
Kquart <- statistics.predictive(Kpred$simul, quantile=c(0.25, 0.5, 0.75))
names(Kquart)
dim(Kquart$quant)


# mapa da medianas
image(Kpred, col=gray(seq(1,0, l=21)),
            x.leg=c(2,20), y.leg=c(-3,-1.3))
title("Mapa da Media")
image(Kpred, val=Kquart$quant[,2], col=gray(seq(1,0, l=21)),
            x.leg=c(2,20), y.leg=c(-3,-1.3))
title("Mapa da Mediana")

# mapas de quantis
image(Kpred, val=Kquart$quant[,1], col=gray(seq(1,0, l=21)),
            x.leg=c(2,20), y.leg=c(-3,-1.3))
title("Mapa do 1o quartil")
image(Kpred, val=Kquart$quant[,3], col=gray(seq(1,0, l=21)),
            x.leg=c(2,20), y.leg=c(-3,-1.3))
title("Mapa do 3o quartil")
